/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ErrorMappingSourceTypeReferencesExist
extends AbstractErrorTypesValidation {
    public ErrorMappingSourceTypeReferencesExist(Optional<FeatureFlaggingService> featureFlaggingService, boolean ignoreParamsWithProperties) {
        super(featureFlaggingService, ignoreParamsWithProperties);
    }

    @Override
    public String getName() {
        return "Error Type references exist";
    }

    @Override
    public String getDescription() {
        return "Referenced error types do exist in the context of the artifact.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(((Predicate<ComponentAst>)this::errorMappingPresent).and(comp -> this.isIgnoreParamsWithProperties() ? this.errorMappingSourceNotPropertyDependant((ComponentAst)comp) : true));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        for (ErrorMapping errorMapping : ErrorMappingSourceTypeReferencesExist.getErrorMappings(component)) {
            ComponentIdentifier errorTypeId = ErrorMappingSourceTypeReferencesExist.parseErrorType(errorMapping.getSource());
            Optional<ErrorType> errorType = artifact.getErrorTypeRepository().lookupErrorType(errorTypeId);
            if (errorType.isPresent()) continue;
            return Optional.of(ValidationResultItem.create(component, component.getParameter("Error Mappings", "errorMappings"), (Validation)this, String.format("Could not find error '%s'.", errorMapping.getSource())));
        }
        return Optional.empty();
    }
}

