/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class InsecureTLSValidation
implements Validation {
    private static final ComponentIdentifier TLS_IDENTIFIER = ComponentIdentifier.builder().namespace("tls").name("trust-store").build();

    @Override
    public String getName() {
        return "Insecure TLS validation";
    }

    @Override
    public String getDescription() {
        return "Warning for insecure communication";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getIdentifier().equals(TLS_IDENTIFIER));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst param2 = component.getParameter("TrustStore", "insecure");
        Object insecure = param2.getValue().getRight();
        if (insecure instanceof Boolean && ((Boolean)insecure).booleanValue()) {
            return Optional.of(ValidationResultItem.create(component, param2, (Validation)this, "Setting insecure to true renders connections vulnerable to attack. Use it only for prototyping or testing. Never use it in production environments."));
        }
        return Optional.empty();
    }
}

