/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.MuleSdkOperationValidation;

public abstract class MuleSdkOperationDoesNotHaveForbiddenComponents
extends MuleSdkOperationValidation {
    protected abstract ComponentIdentifier forbiddenComponentIdentifier();

    @Override
    public String getName() {
        return String.format("Operation doesn't have '%s'", this.forbiddenComponentIdentifier());
    }

    @Override
    public String getDescription() {
        return String.format("Mule SDK Operations cannot have a '%s' component within", this.forbiddenComponentIdentifier());
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.recursiveStream().anyMatch(c -> c.getIdentifier().equals(this.forbiddenComponentIdentifier()))) {
            return Optional.of(ValidationResultItem.create(component, (Validation)this, String.format("Usages of the component '%s' are not allowed inside a Mule SDK Operation Definition (%s)", this.forbiddenComponentIdentifier(), OPERATION_IDENTIFIER)));
        }
        return Optional.empty();
    }
}

