/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.core.internal.expression.util.ExpressionUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.LiteralTypeAnnotation;

public class NoExpressionsInNoExpressionsSupportedParams
implements Validation {
    private static final String FLOW_REF_ELEMENT = "flow-ref";
    private static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("flow-ref").build();

    @Override
    public String getName() {
        return "No expressions in no expressionsSupported params";
    }

    @Override
    public String getDescription() {
        return "No expressions are provided for parameters that do not support expressions.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(ParameterizedModel.class).isPresent()).and(ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier(FLOW_REF_IDENTIFIER).negate()));
    }

    @Override
    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getParameters().stream().filter(param2 -> !param2.getModel().isComponentId()).filter(param2 -> param2.getValueOrResolutionError().isRight() && param2.getResolvedRawValue() instanceof String).filter(param2 -> ExpressionSupport.NOT_SUPPORTED.equals((Object)param2.getModel().getExpressionSupport()) && !param2.getModel().getType().getAnnotation(LiteralTypeAnnotation.class).isPresent()).filter(param2 -> ExpressionUtils.isExpression(param2.getResolvedRawValue())).map(param2 -> ValidationResultItem.create(component, param2, (Validation)this, String.format("An expression value was given for parameter '%s' but it doesn't support expressions", param2.getModel().getName()))).collect(Collectors.toList());
    }
}

