/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.IdentifierParsingUtils;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class OperationRaiseErrorDoesntSpecifyNamespace
implements Validation {
    private static final String OPERATION_PREFIX = "operation";
    private static final String RAISE_ERROR = "raise-error";
    private static final ComponentIdentifier OPERATION_RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("operation").name("raise-error").build();

    @Override
    public String getName() {
        return "Operation raise error doesn't specify namespace";
    }

    @Override
    public String getDescription() {
        return "Operation raise error doesn't specify namespace.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier(OPERATION_RAISE_ERROR_IDENTIFIER));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst errorTypeParam = OperationRaiseErrorDoesntSpecifyNamespace.getErrorTypeParam(component);
        String errorTypeString = errorTypeParam.getResolvedRawValue();
        return IdentifierParsingUtils.getNamespace(errorTypeString).map(s2 -> ValidationResultItem.create(component, errorTypeParam, (Validation)this, String.format("Operation raise error component (%s) is not allowed to specify a namespace: '%s'", OPERATION_RAISE_ERROR_IDENTIFIER, s2)));
    }

    private static ComponentParameterAst getErrorTypeParam(ComponentAst component) {
        return component.getParameter("General", "type");
    }
}

