/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;

public class RaiseErrorReferenceDoNotUseExtensionNamespaces
extends AbstractErrorTypesValidation {
    public RaiseErrorReferenceDoNotUseExtensionNamespaces(Optional<FeatureFlaggingService> featureFlaggingService) {
        super(featureFlaggingService, false);
    }

    @Override
    public String getName() {
        return "Error Type references don't use extension namespaces";
    }

    @Override
    public String getDescription() {
        return "Referenced error types do not use extension namespaces.";
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier(RAISE_ERROR_IDENTIFIER).and(this::isErrorTypePresent));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentIdentifier errorTypeId;
        String namespace;
        ComponentParameterAst errorTypeParam = this.getErrorTypeParam(component);
        String errorTypeString = errorTypeParam.getResolvedRawValue();
        Set<String> alreadyUsedErrorNamespaces = RaiseErrorReferenceDoNotUseExtensionNamespaces.getAlreadyUsedErrorNamespaces(artifact);
        if (alreadyUsedErrorNamespaces.contains(namespace = (errorTypeId = RaiseErrorReferenceDoNotUseExtensionNamespaces.parseErrorType(errorTypeString)).getNamespace()) && !RaiseErrorReferenceDoNotUseExtensionNamespaces.isAllowedBorrowedNamespace(namespace)) {
            return Optional.of(ValidationResultItem.create(component, errorTypeParam, (Validation)this, String.format("Cannot use error type '%s': namespace already exists.", errorTypeString)));
        }
        return Optional.empty();
    }
}

