/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorMappingValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class SourceErrorMappingTypeNotRepeated
extends AbstractErrorMappingValidation {
    @Override
    public String getName() {
        return "Source error-mapping type not repeated";
    }

    @Override
    public String getDescription() {
        return "Error Mappings source types are not repeated.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    protected Optional<ValidationResultItem> validateErrorMapping(ComponentAst component, ComponentParameterAst errorMappingsParam, List<ErrorMapping> mappings) {
        List repeatedSources = mappings.stream().map(ErrorMapping::getSource).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(element -> (Long)element.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!repeatedSources.isEmpty()) {
            return Optional.of(ValidationResultItem.create(component, errorMappingsParam, (Validation)this, String.format("Repeated source types are not allowed. Offending types are '%s'.", Joiner.on("', '").join(repeatedSources))));
        }
        return Optional.empty();
    }
}

