/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.BooleanUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.artifact.ArtifactCoordinates;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.InternalComponent;
import org.mule.runtime.core.api.config.ConfigurationExtension;
import org.mule.runtime.core.api.config.CorrelationIdGenerator;
import org.mule.runtime.core.api.config.DynamicConfigExpiration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.FatalException;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.NetworkUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.core.internal.util.StandaloneServerUtils;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class DefaultMuleConfiguration
implements MuleConfiguration,
MuleContextAware,
InternalComponent,
Initialisable {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMuleConfiguration.class);
    private MuleVersion minMuleVersion;
    public static boolean flowTrace = false;
    private String systemModelType = "seda";
    private String encoding = "UTF-8";
    private int responseTimeout = 10000;
    private int defaultTransactionTimeout = 30000;
    private int defaultQueueTimeout = 200;
    private long shutdownTimeout = 5000L;
    private String workingDirectory = "./.mule";
    private boolean clientMode = false;
    private String id;
    private String clusterId = "";
    private String domainId;
    private boolean cacheMessageAsBytes = true;
    private boolean enableStreaming = true;
    private boolean autoWrapMessageAwareTransform = true;
    private boolean disableTimeouts = false;
    private MuleContext muleContext;
    private boolean containerMode;
    private boolean validateExpressions = true;
    private Map<String, String> extendedProperties = new HashMap<String, String>();
    private String defaultExceptionStrategyName;
    private final List<ConfigurationExtension> extensions = new ArrayList<ConfigurationExtension>();
    private ObjectSerializer defaultObjectSerializer;
    private ProcessingStrategyFactory defaultProcessingStrategyFactory;
    private int maxQueueTransactionFilesSizeInMegabytes = 500;
    private boolean inheritIterableRepeatability = false;
    private Optional<CorrelationIdGenerator> correlationIdGenerationExpression = Optional.empty();
    private ArtifactCoordinates artifactCoordinates;
    @Inject
    private Registry registry;
    private DynamicConfigExpiration dynamicConfigExpiration = DynamicConfigExpiration.getDefault();
    private String dataFolderName;

    public DefaultMuleConfiguration() {
        this(false);
    }

    public DefaultMuleConfiguration(boolean containerMode) {
        this.containerMode = containerMode;
        this.applySystemProperties();
        if (this.id == null) {
            this.id = UUID.getUUID();
        }
        if (this.domainId == null) {
            try {
                this.domainId = NetworkUtils.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.warn("Unable to obtain hostname", e);
                this.domainId = "org.mule.runtime.core";
            }
        }
        try {
            this.validateEncoding();
        }
        catch (FatalException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private void updateWorkingDirectory() {
        if (this.containerMode) {
            String muleBase = StandaloneServerUtils.getMuleBase().map(File::getAbsolutePath).orElse(null);
            this.workingDirectory = !this.isStandalone() ? String.format("%s/%s", this.getWorkingDirectory(), this.getDataFolderName()) : String.format("%s/%s/%s", muleBase.trim(), this.getWorkingDirectory(), this.getDataFolderName());
        } else if (this.isStandalone()) {
            this.workingDirectory = String.format("%s/%s", this.getWorkingDirectory(), this.getDataFolderName());
        }
    }

    protected void applySystemProperties() {
        String p = System.getProperty("mule.encoding");
        if (p != null) {
            this.encoding = p;
        } else {
            System.setProperty("mule.encoding", this.encoding);
        }
        p = System.getProperty("mule.systemModelType");
        if (p != null) {
            this.systemModelType = p;
        }
        if ((p = System.getProperty("mule.workingDirectory")) != null) {
            this.workingDirectory = p;
        }
        if ((p = System.getProperty("mule.clientMode")) != null) {
            this.clientMode = BooleanUtils.toBoolean(p);
        }
        if ((p = System.getProperty("mule.serverId")) != null) {
            this.id = p;
        }
        if ((p = System.getProperty("mule.domainId")) != null) {
            this.domainId = p;
        }
        if ((p = System.getProperty("mule.message.cacheBytes")) != null) {
            this.cacheMessageAsBytes = BooleanUtils.toBoolean(p);
        }
        if ((p = System.getProperty("mule.streaming.enable")) != null) {
            this.enableStreaming = BooleanUtils.toBoolean(p);
        }
        if ((p = System.getProperty("mule.transform.autoWrap")) != null) {
            this.autoWrapMessageAwareTransform = BooleanUtils.toBoolean(p);
        }
        flowTrace = (p = System.getProperty("mule.flowTrace")) != null ? BooleanUtils.toBoolean(p) : false;
        p = System.getProperty("mule.validate.expressions");
        if (p != null) {
            this.validateExpressions = Boolean.valueOf(p);
        }
        if ((p = System.getProperty("mule.timeout.disable")) != null) {
            this.disableTimeouts = Boolean.valueOf(p);
        }
        try {
            p = System.getProperty(ProcessingStrategyFactory.class.getName());
            if (p != null) {
                this.defaultProcessingStrategyFactory = (ProcessingStrategyFactory)ClassUtils.instantiateClass(p, new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.warn("Unable to instantiate ProcessingStrategyFactory '" + p + "', default will be used instead.");
        }
    }

    public static boolean isFlowTrace() {
        return flowTrace;
    }

    protected void validateEncoding() throws FatalException {
        if (!Charset.isSupported(this.encoding)) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("encoding", this.encoding), (Object)this);
        }
    }

    @Deprecated
    public void setDefaultSynchronousEndpoints(boolean synchronous) {
    }

    @Override
    public int getDefaultResponseTimeout() {
        return this.responseTimeout;
    }

    public void setDefaultResponseTimeout(int responseTimeout) {
        if (this.verifyContextNotStarted()) {
            this.responseTimeout = responseTimeout;
        }
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public String getMuleHomeDirectory() {
        return StandaloneServerUtils.getMuleHome().map(File::getAbsolutePath).orElse(null);
    }

    public void setWorkingDirectory(String workingDirectory) {
        if (this.verifyContextNotInitialized()) {
            try {
                File canonicalFile = FileUtils.openDirectory(workingDirectory);
                this.workingDirectory = canonicalFile.getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(CoreMessages.initialisationFailure("Invalid working directory").getMessage(), e);
            }
        }
    }

    public void setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
        this.artifactCoordinates = artifactCoordinates;
    }

    @Override
    public int getDefaultTransactionTimeout() {
        return this.defaultTransactionTimeout;
    }

    public void setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        if (this.verifyContextNotStarted()) {
            this.defaultTransactionTimeout = defaultTransactionTimeout;
        }
    }

    @Override
    public boolean isValidateExpressions() {
        return this.validateExpressions;
    }

    @Override
    public boolean isClientMode() {
        return this.clientMode;
    }

    @Override
    public String getDefaultEncoding() {
        return this.encoding;
    }

    public void setDefaultEncoding(String encoding) {
        if (this.verifyContextNotInitialized()) {
            this.encoding = encoding;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.verifyContextNotInitialized()) {
            if (StringUtils.isBlank(id)) {
                throw new IllegalArgumentException("Cannot set server id to null/blank");
            }
            this.id = id;
        }
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        if (this.verifyContextNotInitialized()) {
            this.domainId = domainId;
        }
    }

    @Override
    public String getSystemModelType() {
        return this.systemModelType;
    }

    @Deprecated
    public void setSystemModelType(String systemModelType) {
        if (this.verifyContextNotStarted()) {
            this.systemModelType = systemModelType;
        }
    }

    @Deprecated
    public void setClientMode(boolean clientMode) {
        if (this.verifyContextNotStarted()) {
            this.clientMode = clientMode;
        }
    }

    @Override
    public String getSystemName() {
        return this.domainId + "." + this.clusterId + "." + this.id;
    }

    @Override
    public boolean isAutoWrapMessageAwareTransform() {
        return this.autoWrapMessageAwareTransform;
    }

    public void setAutoWrapMessageAwareTransform(boolean autoWrapMessageAwareTransform) {
        if (this.verifyContextNotStarted()) {
            this.autoWrapMessageAwareTransform = autoWrapMessageAwareTransform;
        }
    }

    @Override
    public boolean isCacheMessageAsBytes() {
        return this.cacheMessageAsBytes;
    }

    @Deprecated
    public void setCacheMessageAsBytes(boolean cacheMessageAsBytes) {
        if (this.verifyContextNotStarted()) {
            this.cacheMessageAsBytes = cacheMessageAsBytes;
        }
    }

    @Override
    public boolean isEnableStreaming() {
        return this.enableStreaming;
    }

    @Deprecated
    public void setEnableStreaming(boolean enableStreaming) {
        if (this.verifyContextNotStarted()) {
            this.enableStreaming = enableStreaming;
        }
    }

    @Override
    public boolean isLazyInit() {
        return false;
    }

    @Deprecated
    public void setLazyInit(boolean lazyInit) {
    }

    protected boolean verifyContextNotInitialized() {
        if (this.muleContext != null && this.muleContext.getLifecycleManager().isPhaseComplete("initialise")) {
            logger.warn("Cannot modify MuleConfiguration once the MuleContext has been initialized.  Modification will be ignored.");
            return false;
        }
        return true;
    }

    protected boolean verifyContextNotStarted() {
        if (this.muleContext != null && this.muleContext.getLifecycleManager().isPhaseComplete("start")) {
            logger.warn("Cannot modify MuleConfiguration once the MuleContext has been started.  Modification will be ignored.");
            return false;
        }
        return true;
    }

    @Override
    public int getDefaultQueueTimeout() {
        return this.defaultQueueTimeout;
    }

    public void setDefaultQueueTimeout(int defaultQueueTimeout) {
        if (this.verifyContextNotStarted()) {
            this.defaultQueueTimeout = defaultQueueTimeout;
        }
    }

    @Override
    public long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @Override
    public int getMaxQueueTransactionFilesSizeInMegabytes() {
        return this.maxQueueTransactionFilesSizeInMegabytes;
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        if (this.verifyContextNotStarted()) {
            if (shutdownTimeout < 0L) {
                throw new IllegalArgumentException(String.format("'shutdownTimeout' must be a possitive long. %d passed", shutdownTimeout));
            }
            this.shutdownTimeout = shutdownTimeout;
        }
    }

    @Override
    public boolean isContainerMode() {
        return this.containerMode;
    }

    public void setContainerMode(boolean containerMode) {
        if (this.verifyContextNotInitialized()) {
            this.containerMode = containerMode;
        }
    }

    @Override
    public boolean isStandalone() {
        return this.getMuleHomeDirectory() != null;
    }

    public Map<String, String> getExtendedProperties() {
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map<String, String> extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    public void setExtendedProperty(String name, String value) {
        this.extendedProperties.put(name, value);
    }

    public String getExtendedProperty(String name) {
        return this.extendedProperties.get(name);
    }

    @Override
    public String getDefaultErrorHandlerName() {
        return this.defaultExceptionStrategyName;
    }

    public void setDefaultErrorHandlerName(String defaultExceptionStrategyName) {
        this.defaultExceptionStrategyName = defaultExceptionStrategyName;
    }

    public void setMaxQueueTransactionFilesSize(int maxQueueTransactionFilesSizeInMegabytes) {
        this.maxQueueTransactionFilesSizeInMegabytes = maxQueueTransactionFilesSizeInMegabytes;
    }

    @Override
    public boolean isDisableTimeouts() {
        return this.disableTimeouts;
    }

    @Override
    public ObjectSerializer getDefaultObjectSerializer() {
        return this.defaultObjectSerializer;
    }

    @Override
    public ProcessingStrategyFactory getDefaultProcessingStrategyFactory() {
        return this.defaultProcessingStrategyFactory;
    }

    public void setDefaultProcessingStrategyFactory(ProcessingStrategyFactory defaultProcessingStrategy) {
        this.defaultProcessingStrategyFactory = defaultProcessingStrategy;
    }

    @Override
    public DynamicConfigExpiration getDynamicConfigExpiration() {
        return this.dynamicConfigExpiration;
    }

    public void setDynamicConfigExpiration(DynamicConfigExpiration dynamicConfigExpiration) {
        this.dynamicConfigExpiration = dynamicConfigExpiration;
    }

    public void setDefaultObjectSerializer(ObjectSerializer defaultObjectSerializer) {
        this.defaultObjectSerializer = defaultObjectSerializer;
    }

    public String getDataFolderName() {
        return this.dataFolderName != null ? this.dataFolderName : this.getId();
    }

    public void setDataFolderName(String dataFolderName) {
        this.dataFolderName = dataFolderName;
        this.updateWorkingDirectory();
    }

    public void setInheritIterableRepeatability(String inheritIterableRepeatability) {
        this.inheritIterableRepeatability = Boolean.parseBoolean(inheritIterableRepeatability);
    }

    public void setInheritIterableRepeatability(boolean inheritIterableRepeatability) {
        this.inheritIterableRepeatability = inheritIterableRepeatability;
    }

    public void addExtensions(List<ConfigurationExtension> extensions) {
        this.extensions.addAll(extensions);
    }

    @Override
    public <T> T getExtension(Class<T> extensionType) {
        return this.extensions.stream().filter(object -> extensionType.isAssignableFrom(object.getClass())).findFirst().orElse(null);
    }

    public List<ConfigurationExtension> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.extensions);
    }

    @Override
    public boolean isInheritIterableRepeatability() {
        return this.inheritIterableRepeatability;
    }

    @Override
    public Optional<MuleVersion> getMinMuleVersion() {
        return Optional.ofNullable(this.minMuleVersion);
    }

    public void setMinMuleVersion(MuleVersion minMuleversion) {
        this.minMuleVersion = minMuleversion;
    }

    @Override
    public Optional<CorrelationIdGenerator> getDefaultCorrelationIdGenerator() {
        return this.correlationIdGenerationExpression;
    }

    @Override
    public Optional<ArtifactCoordinates> getArtifactCoordinates() {
        return Optional.ofNullable(this.artifactCoordinates);
    }

    public void setDefaultCorrelationIdGenerator(CorrelationIdGenerator generator) {
        this.correlationIdGenerationExpression = Optional.of(generator);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.autoWrapMessageAwareTransform ? 1231 : 1237);
        result = 31 * result + (this.cacheMessageAsBytes ? 1231 : 1237);
        result = 31 * result + (this.clientMode ? 1231 : 1237);
        result = 31 * result + this.defaultQueueTimeout;
        result = 31 * result + this.defaultTransactionTimeout;
        result = 31 * result + this.maxQueueTransactionFilesSizeInMegabytes;
        result = 31 * result + (this.domainId == null ? 0 : this.domainId.hashCode());
        result = 31 * result + (this.enableStreaming ? 1231 : 1237);
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.responseTimeout;
        result = 31 * result + new Long(this.shutdownTimeout).hashCode();
        result = 31 * result + (this.systemModelType == null ? 0 : this.systemModelType.hashCode());
        result = 31 * result + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        result = 31 * result + (this.containerMode ? 1231 : 1237);
        result = 31 * result + (this.inheritIterableRepeatability ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultMuleConfiguration other = (DefaultMuleConfiguration)obj;
        if (this.autoWrapMessageAwareTransform != other.autoWrapMessageAwareTransform) {
            return false;
        }
        if (this.cacheMessageAsBytes != other.cacheMessageAsBytes) {
            return false;
        }
        if (this.clientMode != other.clientMode) {
            return false;
        }
        if (this.defaultQueueTimeout != other.defaultQueueTimeout) {
            return false;
        }
        if (this.defaultTransactionTimeout != other.defaultTransactionTimeout) {
            return false;
        }
        if (this.domainId == null ? other.domainId != null : !this.domainId.equals(other.domainId)) {
            return false;
        }
        if (this.enableStreaming != other.enableStreaming) {
            return false;
        }
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.responseTimeout != other.responseTimeout) {
            return false;
        }
        if (this.shutdownTimeout != other.shutdownTimeout) {
            return false;
        }
        if (this.systemModelType == null ? other.systemModelType != null : !this.systemModelType.equals(other.systemModelType)) {
            return false;
        }
        if (this.workingDirectory == null ? other.workingDirectory != null : !this.workingDirectory.equals(other.workingDirectory)) {
            return false;
        }
        if (this.containerMode != other.containerMode) {
            return false;
        }
        if (this.maxQueueTransactionFilesSizeInMegabytes != other.maxQueueTransactionFilesSizeInMegabytes) {
            return false;
        }
        return this.inheritIterableRepeatability == other.inheritIterableRepeatability;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.initialiseAndValidateDefaultErrorHandler();
    }

    private void initialiseAndValidateDefaultErrorHandler() throws InitialisationException {
        MessagingExceptionHandlerAcceptor messagingExceptionHandlerAcceptor;
        FlowExceptionHandler messagingExceptionHandler;
        String defaultErrorHandler = this.getDefaultErrorHandlerName();
        if (defaultErrorHandler != null && (messagingExceptionHandler = (FlowExceptionHandler)this.registry.lookupByName(defaultErrorHandler).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage(String.format("No global error handler defined with name '%s'.", defaultErrorHandler)), (Initialisable)this))) instanceof MessagingExceptionHandlerAcceptor && !(messagingExceptionHandlerAcceptor = (MessagingExceptionHandlerAcceptor)messagingExceptionHandler).acceptsAll()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Default exception strategy must not have expression attribute. It must accept any message."), (Initialisable)this);
        }
    }
}

