/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.exception;

import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.exception.BaseExceptionHandler;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class LoggingExceptionHandler
extends BaseExceptionHandler {
    private static final LoggingExceptionHandler INSTANCE = new LoggingExceptionHandler();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingExceptionHandler.class);

    private LoggingExceptionHandler() {
    }

    public static FlowExceptionHandler getInstance() {
        return INSTANCE;
    }

    @Override
    protected void onError(Exception exception) {
        MuleException me = ExceptionHelper.getRootMuleException(exception);
        if (me != null) {
            LOGGER.error(me.getDetailedMessage());
        } else {
            LOGGER.error("'{}: {}' has occurred.", exception.getClass().getName(), exception.getMessage(), exception);
        }
    }

    public String toString() {
        return LoggingExceptionHandler.class.getSimpleName();
    }
}

