/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.retry.policy;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.retry.policy.PolicyStatus;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.util.rx.ImmediateScheduler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@NoImplement
public interface RetryPolicy {
    public PolicyStatus applyPolicy(Throwable var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> CompletableFuture<T> applyPolicy(Supplier<CompletableFuture<T>> futureSupplier, Predicate<Throwable> shouldRetry, Consumer<Throwable> onRetry, Consumer<Throwable> onExhausted, Function<Throwable, Throwable> errorFunction, Scheduler retryScheduler) {
        CompletableFuture completedFuture = new CompletableFuture();
        try {
            CompletableFuture<T> retry = futureSupplier.get();
            retry.whenComplete((v, e) -> {
                if (e != null) {
                    try {
                        e = (Throwable)errorFunction.apply(Exceptions.unwrap(e));
                        onExhausted.accept((Throwable)e);
                    }
                    finally {
                        completedFuture.completeExceptionally((Throwable)e);
                    }
                } else {
                    completedFuture.complete(v);
                }
            });
        }
        catch (Throwable t2) {
            try {
                t2 = errorFunction.apply(Exceptions.unwrap(t2));
                onExhausted.accept(t2);
                completedFuture.completeExceptionally(t2);
            }
            catch (Throwable throwable) {
                completedFuture.completeExceptionally(t2);
                throw throwable;
            }
        }
        return completedFuture;
    }

    @Deprecated
    default public <T> Publisher<T> applyPolicy(Publisher<T> publisher, Predicate<Throwable> shouldRetry, Consumer<Throwable> onExhausted, Function<Throwable, Throwable> errorFunction) {
        return this.applyPolicy(publisher, shouldRetry, onExhausted, errorFunction, ImmediateScheduler.IMMEDIATE_SCHEDULER);
    }

    default public <T> Publisher<T> applyPolicy(Publisher<T> publisher, Predicate<Throwable> shouldRetry, Consumer<Throwable> onExhausted, Function<Throwable, Throwable> errorFunction, Scheduler retryScheduler) {
        return Mono.from(publisher).onErrorMap(e -> {
            e = Exceptions.unwrap(e);
            onExhausted.accept((Throwable)e);
            return (Throwable)errorFunction.apply((Throwable)e);
        });
    }
}

