/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.rx;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.util.func.CheckedBiConsumer;
import org.mule.runtime.core.api.util.func.CheckedBiFunction;
import org.mule.runtime.core.api.util.func.CheckedBiPredicate;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.mule.runtime.core.api.util.func.CheckedPredicate;

public class Exceptions {
    private static final String REACTIVE_EXCEPTION_CLASS_NAME = "reactor.core.Exceptions$ReactiveException";

    public static <T> Consumer<T> checkedConsumer(CheckedConsumer<T> checkedConsumer) {
        return t2 -> checkedConsumer.accept(t2);
    }

    public static <T, U> BiConsumer<T, U> checkedConsumer(CheckedBiConsumer<T, U> checkedBiConsumer) {
        return (t2, u) -> checkedBiConsumer.accept(t2, u);
    }

    public static <T, R> Function<T, R> checkedFunction(CheckedFunction<T, R> checkedFunction) {
        return t2 -> checkedFunction.apply(t2);
    }

    public static <T, U, R> BiFunction<T, U, R> checkedFunction(CheckedBiFunction<T, U, R> checkedBiFunction) {
        return (t2, u) -> checkedBiFunction.apply(t2, u);
    }

    public static <T, U> BiConsumer<T, U> checkedBiConsumer(CheckedBiConsumer<T, U> checkedBiConsumer) {
        return checkedBiConsumer::accept;
    }

    public static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> checkedPredicate) {
        return t2 -> checkedPredicate.test(t2);
    }

    public static <T, U> BiPredicate<T, U> checkedPredicate(CheckedBiPredicate<T, U> checkedBiPredicate) {
        return (t2, u) -> checkedBiPredicate.test(t2, u);
    }

    public static MuleException rxExceptionToMuleException(Throwable throwable) throws MuleException {
        if ((throwable = Exceptions.unwrap(throwable)) instanceof MuleException) {
            return (MuleException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new DefaultMuleException(throwable);
    }

    public static Throwable unwrap(Throwable throwable) {
        while (throwable.getClass().getName().equals(REACTIVE_EXCEPTION_CLASS_NAME)) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static RuntimeException propagateWrappingFatal(Throwable t2) {
        return reactor.core.Exceptions.propagate(Exceptions.wrapFatal(t2));
    }

    public static Throwable wrapFatal(Throwable t2) {
        if (t2 instanceof LinkageError) {
            return new MuleFatalException(t2);
        }
        if (t2 instanceof VirtualMachineError) {
            return new MuleFatalException(t2);
        }
        if (reactor.core.Exceptions.isBubbling(t2)) {
            return new MuleRuntimeException(Exceptions.unwrap(t2));
        }
        if (reactor.core.Exceptions.isErrorCallbackNotImplemented(t2)) {
            return new MuleRuntimeException(Exceptions.unwrap(t2));
        }
        return t2;
    }

    private Exceptions() {
    }
}

