/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.iterator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.core.api.streaming.iterator.Consumer;
import org.mule.runtime.core.api.streaming.iterator.Producer;
import org.mule.runtime.core.internal.streaming.object.iterator.ClosedConsumerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public abstract class AbstractConsumer<T, P>
implements Consumer<T> {
    private static final transient Logger logger = LoggerFactory.getLogger(AbstractConsumer.class);
    protected final Producer<P> producer;
    private boolean closed = false;

    public AbstractConsumer(Producer<P> producer) {
        this.producer = producer;
    }

    protected abstract T doConsume() throws NoSuchElementException;

    protected abstract boolean checkConsumed();

    @Override
    public final T consume() throws NoSuchElementException {
        if (this.closed) {
            throw new ClosedConsumerException("this consumer is already closed");
        }
        if (this.isConsumed()) {
            throw new NoSuchElementException();
        }
        T value = this.doConsume();
        if (value == null) {
            this.closeQuietly();
        }
        return value;
    }

    @Override
    public final boolean isConsumed() {
        if (this.closed) {
            return true;
        }
        boolean isConsumed = this.checkConsumed();
        if (isConsumed) {
            this.closeQuietly();
        }
        return isConsumed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.producer.close();
    }

    @Override
    public int getSize() {
        return this.producer.getSize();
    }

    private void closeQuietly() {
        block2: {
            try {
                this.close();
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Exception was trapped trying to close consumer", e);
            }
        }
    }
}

