/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction;

import java.util.Objects;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleTransactionConfig
implements TransactionConfig,
MuleContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(MuleTransactionConfig.class);
    public static final String ACTION_NONE_STRING = "NONE";
    public static final String ACTION_ALWAYS_BEGIN_STRING = "ALWAYS_BEGIN";
    public static final String ACTION_BEGIN_OR_JOIN_STRING = "BEGIN_OR_JOIN";
    public static final String ACTION_ALWAYS_JOIN_STRING = "ALWAYS_JOIN";
    public static final String ACTION_JOIN_IF_POSSIBLE_STRING = "JOIN_IF_POSSIBLE";
    public static final String ACTION_NEVER_STRING = "NEVER";
    public static final String ACTION_INDIFFERENT_STRING = "INDIFFERENT";
    public static final String ACTION_NOT_SUPPORTED_STRING = "NOT_SUPPORTED";
    private TransactionFactory factory;
    private byte action = (byte)6;
    private Integer timeout;
    private boolean interactWithExternal = false;

    public MuleTransactionConfig() {
    }

    public MuleTransactionConfig(byte action) {
        this.action = action;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        if (this.timeout == null) {
            this.timeout = context.getConfiguration().getDefaultTransactionTimeout();
        }
    }

    @Override
    public TransactionFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(TransactionFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Transaction Factory cannot be null");
        }
        this.factory = factory;
    }

    @Override
    public byte getAction() {
        return this.action;
    }

    @Override
    public void setAction(byte action) {
        this.action = action;
    }

    @Override
    public boolean isInteractWithExternal() {
        return this.interactWithExternal;
    }

    @Override
    public void setInteractWithExternal(boolean interactWithExternal) {
        this.interactWithExternal = interactWithExternal;
    }

    public void setActionAsString(String action) {
        if (ACTION_ALWAYS_BEGIN_STRING.equals(action)) {
            this.action = 1;
        } else if (ACTION_BEGIN_OR_JOIN_STRING.equals(action)) {
            this.action = (byte)2;
        } else if (ACTION_ALWAYS_JOIN_STRING.equals(action)) {
            this.action = (byte)3;
        } else if (ACTION_JOIN_IF_POSSIBLE_STRING.equals(action)) {
            this.action = (byte)4;
        } else if (ACTION_NONE_STRING.equals(action)) {
            this.action = 0;
        } else if (ACTION_NEVER_STRING.equals(action)) {
            this.action = (byte)5;
        } else if (ACTION_INDIFFERENT_STRING.equals(action)) {
            this.action = (byte)6;
        } else if (ACTION_NOT_SUPPORTED_STRING.equals(action)) {
            this.action = (byte)7;
        } else {
            throw new IllegalArgumentException("Action " + action + " is not recognised as a begin action.");
        }
    }

    public String getActionAsString() {
        switch (this.action) {
            case 1: {
                return ACTION_ALWAYS_BEGIN_STRING;
            }
            case 2: {
                return ACTION_BEGIN_OR_JOIN_STRING;
            }
            case 3: {
                return ACTION_ALWAYS_JOIN_STRING;
            }
            case 4: {
                return ACTION_JOIN_IF_POSSIBLE_STRING;
            }
            case 0: {
                return ACTION_NONE_STRING;
            }
            case 6: {
                return ACTION_INDIFFERENT_STRING;
            }
        }
        return ACTION_NEVER_STRING;
    }

    @Override
    public boolean isTransacted() {
        if (this.action == 5 || this.action == 0 || this.action == 7) {
            return false;
        }
        if (this.factory == null) {
            if (this.action != 6) {
                throw new MuleRuntimeException(CoreMessages.transactionFactoryIsMandatory(this.getActionAsString()));
            }
        } else if (!this.factory.isTransacted()) {
            return false;
        }
        switch (this.action) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case 4: 
            case 6: {
                return TransactionCoordination.getInstance().getTransaction() != null;
            }
        }
        return false;
    }

    @Override
    public boolean isConfigured() {
        return this.factory != null;
    }

    @Override
    public int getTimeout() {
        return this.timeout == null ? 0 : this.timeout;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Transaction{factory=").append(this.factory).append(", action=").append(this.getActionAsString()).append(", timeout=").append(this.timeout == null ? 0 : this.timeout).append("}");
        return buf.toString();
    }

    public int hashCode() {
        return Objects.hash(this.factory, this.action, this.timeout == null ? 0 : this.timeout);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MuleTransactionConfig other = (MuleTransactionConfig)obj;
        return Objects.equals(this.factory, other.factory) && Objects.equals(this.action, other.action) && Objects.equals(this.timeout, other.timeout);
    }
}

