/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.Collection;

public final class WildcardAttributeEvaluator {
    private final String escapedValue;
    private final Boolean hasWildcards;

    public WildcardAttributeEvaluator(String attributeValue) {
        if (attributeValue == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.escapedValue = attributeValue.replaceAll("\\*", "*");
        this.hasWildcards = attributeValue.startsWith("*") || attributeValue.endsWith("*") && !attributeValue.endsWith("\\*") || attributeValue.equals("*");
    }

    public boolean hasWildcards() {
        return this.hasWildcards;
    }

    public void processValues(Collection<String> values, MatchCallback matchCallback) {
        if (!this.hasWildcards()) {
            throw new IllegalStateException("Can't call processValues with non wildcard attribute");
        }
        for (String value : values) {
            if (!this.matches(value)) continue;
            matchCallback.processMatch(value);
        }
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        if (this.escapedValue.equals("*")) {
            return true;
        }
        if (this.escapedValue.startsWith("*")) {
            return value.endsWith(this.escapedValue.substring(1, this.escapedValue.length()));
        }
        if (this.escapedValue.endsWith("*")) {
            return value.startsWith(this.escapedValue.substring(0, this.escapedValue.length() - 1));
        }
        return false;
    }

    public static interface MatchCallback {
        public void processMatch(String var1);
    }
}

