/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.component;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Empty;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperMethod;
import net.bytebuddy.implementation.bind.annotation.This;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.internal.component.DynamicallyComponent;

public class AnnotatedObjectInvocationHandlerInterceptors {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, A> T removeDynamicAnnotations(A annotated) {
        if (annotated instanceof DynamicallyComponent) {
            Class<?> baseClass = annotated.getClass().getSuperclass();
            HashMap<String, Object> fieldsByName = new HashMap<String, Object>();
            for (Class<?> currentClass = baseClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
                Field[] targetFields = currentClass.getDeclaredFields();
                for (Field field2 : targetFields) {
                    if (Modifier.isStatic(field2.getModifiers()) || fieldsByName.containsKey(field2.getName())) continue;
                    fieldsByName.put(field2.getName(), field2);
                }
            }
            try {
                Object base = baseClass.newInstance();
                for (Field field3 : fieldsByName.values()) {
                    boolean acc2 = field3.isAccessible();
                    field3.setAccessible(true);
                    try {
                        field3.set(base, field3.get(annotated));
                    }
                    finally {
                        field3.setAccessible(acc2);
                    }
                }
                return (T)base;
            }
            catch (Exception e) {
                throw new MuleRuntimeException(e);
            }
        }
        return (T)annotated;
    }

    public static class ToStringInterceptor {
        @RuntimeType
        public Object intercept(@This Object obj, @Origin Method method, @AllArguments Object[] args, @SuperMethod Method superMethod) throws Throwable {
            String base = obj.getClass().getName() + "@" + Integer.toHexString(obj.hashCode()) + "; location: ";
            if (((Component)obj).getLocation() != null) {
                return base + ((Component)obj).getLocation().getLocation();
            }
            return base + "(null)";
        }
    }

    public static class RemoveDynamicAnnotationsInterceptor {
        @RuntimeType
        public Object intercept(@This Object obj, @Origin Method method, @AllArguments Object[] args, @SuperMethod(nullIfImpossible=true) Method superMethod, @Empty Object defaultValue) throws Throwable {
            return AnnotatedObjectInvocationHandlerInterceptors.removeDynamicAnnotations(obj);
        }
    }

    public static class ComponentInterceptor
    extends AbstractComponent {
        private final Map<Method, Method> overridingMethods = Collections.synchronizedMap(new HashMap());

        public ComponentInterceptor(Set<Method> managedMethods) {
            for (Method method : managedMethods) {
                this.overridingMethods.put(method, method);
            }
        }

        @RuntimeType
        public Object intercept(@This Object obj, @Origin Method method, @AllArguments Object[] args, @SuperMethod(nullIfImpossible=true) Method superMethod, @Empty Object defaultValue) throws Throwable {
            if (this.overridingMethods.containsKey(method)) {
                return this.overridingMethods.get(method).invoke((Object)this, args);
            }
            return defaultValue;
        }

        public Set<Method> getOverridingMethods() {
            return this.overridingMethods.keySet();
        }
    }
}

