/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.InternalCustomizationService;

public class DefaultCustomizationService
implements InternalCustomizationService {
    private final Map<String, CustomService> muleContextDefaultServices = new HashMap<String, CustomService>();
    private final Map<String, CustomService> customServices = new HashMap<String, CustomService>();

    @Override
    public <T> void overrideDefaultServiceImpl(String serviceId, T serviceImpl) {
        this.muleContextDefaultServices.put(serviceId, new CustomService(serviceId, serviceInterceptor -> serviceInterceptor.overrideServiceImpl(serviceImpl)));
    }

    @Override
    public <T> void interceptDefaultServiceImpl(String serviceId, Consumer<CustomizationService.ServiceInterceptor<T>> serviceInterceptor) {
        this.muleContextDefaultServices.put(serviceId, new CustomService<T>(serviceId, serviceInterceptor));
    }

    @Override
    public <T> void overrideDefaultServiceClass(String serviceId, Class<T> serviceClass) {
        this.muleContextDefaultServices.put(serviceId, new CustomService<T>(serviceId, serviceClass));
    }

    @Override
    public Optional<CustomService> getOverriddenService(String serviceId) {
        return Optional.ofNullable(this.muleContextDefaultServices.get(serviceId));
    }

    @Override
    public <T> void registerCustomServiceImpl(String serviceId, T serviceImpl) {
        Preconditions.checkArgument(!StringUtils.isEmpty(serviceId), "serviceId cannot be empty");
        Preconditions.checkArgument(serviceImpl != null, "serviceImpl cannot be null");
        this.customServices.put(serviceId, new CustomService(serviceId, serviceInterceptor -> serviceInterceptor.overrideServiceImpl(serviceImpl)));
    }

    @Override
    public <T> void registerCustomServiceClass(String serviceId, Class<T> serviceClass) {
        Preconditions.checkArgument(!StringUtils.isEmpty(serviceId), "serviceId cannot be empty");
        Preconditions.checkArgument(serviceClass != null, "serviceClass cannot be null");
        this.customServices.put(serviceId, new CustomService<T>(serviceId, serviceClass));
    }

    @Override
    public Map<String, CustomService> getCustomServices() {
        return Collections.unmodifiableMap(this.customServices);
    }

    @Override
    public Map<String, CustomService> getDefaultServices() {
        return Collections.unmodifiableMap(this.muleContextDefaultServices);
    }
}

