/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import java.util.LinkedList;
import org.mule.runtime.api.legacy.exception.ExceptionReader;

public final class ExceptionHelper
extends org.mule.runtime.api.exception.ExceptionHelper {
    private ExceptionHelper() {
    }

    public static <T> T traverseCauseHierarchy(Throwable e, ExceptionEvaluator<T> evaluator) {
        LinkedList<Throwable> exceptions = new LinkedList<Throwable>();
        exceptions.add(e);
        while (e.getCause() != null && !e.getCause().equals(e)) {
            exceptions.addFirst(e.getCause());
            e = e.getCause();
        }
        for (Throwable exception : exceptions) {
            T value = evaluator.evaluate(exception);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static String writeException(Throwable t2) {
        ExceptionReader er = ExceptionHelper.getExceptionReader(t2);
        StringBuilder msg = new StringBuilder();
        msg.append(er.getMessage(t2)).append(". Type: ").append(t2.getClass());
        return msg.toString();
    }

    public static interface ExceptionEvaluator<T> {
        public T evaluate(Throwable var1);
    }
}

