/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.ListenerSubscriptionPair;
import org.mule.runtime.core.api.context.notification.NotifierCallback;
import org.mule.runtime.core.internal.context.notification.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Policy {
    private static final Logger LOGGER = LoggerFactory.getLogger(Policy.class);
    private Map<Class<? extends Notification>, Collection<Sender>> eventToSenders = new HashMap<Class<? extends Notification>, Collection<Sender>>();
    private Map<Class<? extends Notification>, Collection<Sender>> concreteEventToSenders = new ConcurrentHashMap<Class<? extends Notification>, Collection<Sender>>();
    private ConcurrentMap<Class, Boolean> knownEventsExact = new ConcurrentHashMap<Class, Boolean>();
    private ConcurrentMap<Class, Boolean> knownEventsSuper = new ConcurrentHashMap<Class, Boolean>();

    Policy(Map<Class<? extends NotificationListener>, Set<Class<? extends Notification>>> interfaceToEvents, Set<ListenerSubscriptionPair> listenerSubscriptionPairs, Set<Class<? extends NotificationListener>> disabledInterfaces, Set<Class<? extends Notification>> disabledEvents) {
        for (ListenerSubscriptionPair pair : listenerSubscriptionPairs) {
            NotificationListener listener = pair.getListener();
            for (Class<? extends NotificationListener> iface : interfaceToEvents.keySet()) {
                if (!Policy.notASubclassOfAnyClassInSet(disabledInterfaces, iface) || !iface.isAssignableFrom(listener.getClass())) continue;
                Set<Class<? extends Notification>> events = interfaceToEvents.get(iface);
                for (Class<? extends Notification> event : events) {
                    if (!Policy.notASubclassOfAnyClassInSet(disabledEvents, event)) continue;
                    this.knownEventsExact.put(event, Boolean.TRUE);
                    this.knownEventsSuper.put(event, Boolean.TRUE);
                    if (!this.eventToSenders.containsKey(event)) {
                        this.eventToSenders.put(event, new ArrayList());
                    }
                    this.eventToSenders.get(event).add(new Sender(pair));
                }
            }
        }
    }

    protected static boolean notASubclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!disabled.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    protected static boolean notASuperclassOfAnyClassInSet(Set set, Class clazz) {
        for (Class disabled : set) {
            if (!clazz.isAssignableFrom(disabled)) continue;
            return false;
        }
        return true;
    }

    public void dispatch(Notification notification, NotifierCallback notifier) {
        if (null != notification) {
            boolean found;
            Class<?> notfnClass = notification.getClass();
            Boolean eventKnown = (Boolean)this.knownEventsExact.get(notfnClass);
            if (eventKnown == null) {
                boolean found2 = this.doDispatch(notification, notfnClass, notifier);
                this.knownEventsExact.put(notfnClass, found2);
            } else if (eventKnown.booleanValue() && !(found = this.doDispatch(notification, notfnClass, notifier))) {
                this.knownEventsExact.put(notfnClass, found);
            }
        }
    }

    protected boolean doDispatch(Notification notification, Class<? extends Notification> notfnClass, NotifierCallback notifier) {
        Collection<Sender> senders = this.concreteEventToSenders.get(notfnClass);
        if (senders != null) {
            this.dispatchToSenders(notification, senders, notifier);
            return true;
        }
        senders = new ArrayList<Sender>();
        for (Map.Entry<Class<? extends Notification>, Collection<Sender>> event : this.eventToSenders.entrySet()) {
            if (!event.getKey().isAssignableFrom(notfnClass)) continue;
            senders.addAll(event.getValue());
        }
        if (!senders.isEmpty()) {
            this.dispatchToSenders(notification, senders, notifier);
            this.concreteEventToSenders.putIfAbsent(notfnClass, senders);
        }
        return !senders.isEmpty();
    }

    private void dispatchToSenders(Notification notification, Collection<Sender> senders, NotifierCallback notifier) {
        for (Sender sender : senders) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Sending notification: " + notification.toString());
                }
                sender.dispatch(notification, notifier);
            }
            catch (Throwable e) {
                LOGGER.info("NotificationListener {} was unable to fire notification {} due to an exception: {}.", sender.getListener(), notification, e);
            }
        }
    }

    public boolean isNotificationEnabled(Class notfnClass) {
        Boolean knownExact;
        Boolean knownSuper = (Boolean)this.knownEventsSuper.get(notfnClass);
        if (knownSuper == null) {
            boolean found = false;
            Iterator events = this.knownEventsSuper.keySet().iterator();
            while (events.hasNext() && !found) {
                Class event = (Class)events.next();
                found = (Boolean)this.knownEventsSuper.get(event) != false && notfnClass.isAssignableFrom(event);
            }
            knownSuper = found;
            this.knownEventsSuper.put(notfnClass, found);
        }
        if ((knownExact = (Boolean)this.knownEventsExact.get(notfnClass)) == null) {
            boolean found = false;
            Iterator<Class<? extends Notification>> events = this.eventToSenders.keySet().iterator();
            while (events.hasNext() && !found) {
                Class<? extends Notification> event = events.next();
                found = event.isAssignableFrom(notfnClass);
            }
            knownExact = found;
            this.knownEventsExact.put(notfnClass, knownExact);
        }
        return knownSuper != false || knownExact != false;
    }
}

