/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.config.MuleProperties;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.el.ExpressionLanguageSessionAdaptor;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionLanguageAdaptorHandler
implements ExtendedExpressionLanguageAdaptor,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpressionLanguageAdaptorHandler.class);
    private static final String EXPR_PREFIX_LANGS_TOKEN = "LANGS";
    private static final String EXPR_PREFIX_PATTERN_TEMPLATE = "^\\s*(?:(?:#\\[)?\\s*(LANGS):|\\%(LANGS) \\d).*";
    static final String MVEL_NOT_INSTALLED_ERROR = "MVEL expression language configured as default but not installed";
    private final Pattern exprPrefixPattern;
    private Map<String, ExtendedExpressionLanguageAdaptor> expressionLanguages;
    private LoadingCache<String, ExtendedExpressionLanguageAdaptor> expressionLanguagesByExpressionCache = Caffeine.newBuilder().build(expression -> {
        String languagePrefix = this.resolveLanguagePrefix((String)expression);
        ExtendedExpressionLanguageAdaptor extendedExpressionLanguageAdaptor = this.expressionLanguages.get(languagePrefix);
        if (extendedExpressionLanguageAdaptor == null) {
            throw new IllegalStateException(String.format("There is no expression language registered for '%s'", languagePrefix));
        }
        return extendedExpressionLanguageAdaptor;
    });
    private boolean melDefault = false;

    public ExpressionLanguageAdaptorHandler(ExtendedExpressionLanguageAdaptor defaultExtendedExpressionLanguage, ExtendedExpressionLanguageAdaptor mvelExpressionLanguage) {
        this.expressionLanguages = SmallMap.of("dw", defaultExtendedExpressionLanguage);
        if (mvelExpressionLanguage != null) {
            this.expressionLanguages.put("mel", mvelExpressionLanguage);
        }
        this.exprPrefixPattern = Pattern.compile(EXPR_PREFIX_PATTERN_TEMPLATE.replaceAll(EXPR_PREFIX_LANGS_TOKEN, StringUtils.join(this.expressionLanguages.keySet(), '|')));
        this.melDefault = MuleProperties.isMelDefault();
        if (this.isMelDefault() && mvelExpressionLanguage == null) {
            throw new IllegalStateException(MVEL_NOT_INSTALLED_ERROR);
        }
    }

    boolean isMelDefault() {
        return this.melDefault;
    }

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionLanguages.get("dw").addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, BindingContext context) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, BindingContext context) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, expectedOutputType, event, context);
    }

    @Override
    public TypedValue evaluate(String expression, DataType expectedOutputType, CoreEvent event, ComponentLocation componentLocation, BindingContext context, boolean failOnNull) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, expectedOutputType, event, componentLocation, context, failOnNull);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, componentLocation, bindingContext);
    }

    @Override
    public TypedValue<?> evaluateLogExpression(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluateLogExpression(expression, event, componentLocation, bindingContext);
    }

    @Override
    public ValidationResult validate(String expression) {
        return this.selectExpressionLanguage(expression).validate(expression);
    }

    @Override
    public TypedValue evaluate(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).evaluate(expression, event, eventBuilder, componentLocation, bindingContext);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).split(expression, event, componentLocation, bindingContext);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.selectExpressionLanguage(expression).split(expression, event, bindingContext);
    }

    @Override
    public CompiledExpression compile(String expression, BindingContext bindingContext) {
        return this.selectExpressionLanguage(expression).compile(expression, bindingContext);
    }

    private ExtendedExpressionLanguageAdaptor selectExpressionLanguage(String expression) {
        return this.expressionLanguagesByExpressionCache.get(expression);
    }

    public String getLanguagePrefix(String expression) {
        Matcher matcher = this.exprPrefixPattern.matcher(expression);
        if (matcher.find()) {
            int i = 1;
            String currentGroup = null;
            while (currentGroup == null) {
                currentGroup = matcher.group(i++);
            }
            return currentGroup;
        }
        return null;
    }

    @Override
    public ExpressionLanguageSessionAdaptor openSession(ComponentLocation componentLocation, CoreEvent event, BindingContext bindingContext) {
        final SmallMap<String, ExpressionLanguageSessionAdaptor> sessions = new SmallMap<String, ExpressionLanguageSessionAdaptor>();
        for (Map.Entry<String, ExtendedExpressionLanguageAdaptor> exprLangEntry : this.expressionLanguages.entrySet()) {
            if ("mel".equals(exprLangEntry.getKey()) && event == null) continue;
            sessions.put(exprLangEntry.getKey(), exprLangEntry.getValue().openSession(componentLocation, event, bindingContext));
        }
        return new ExpressionLanguageSessionAdaptor(){

            @Override
            public TypedValue<?> evaluate(String expression, DataType expectedOutputType) throws ExpressionRuntimeException {
                return this.resolveSessionForLanguage(sessions, expression).evaluate(expression, expectedOutputType);
            }

            @Override
            public TypedValue<?> evaluate(String expression) throws ExpressionRuntimeException {
                return this.resolveSessionForLanguage(sessions, expression).evaluate(expression);
            }

            @Override
            public TypedValue<?> evaluate(String expression, long timeout) throws ExpressionRuntimeException {
                return this.resolveSessionForLanguage(sessions, expression).evaluate(expression, timeout);
            }

            @Override
            public TypedValue<?> evaluateLogExpression(String expression) throws ExpressionRuntimeException {
                return this.resolveSessionForLanguage(sessions, expression).evaluateLogExpression(expression);
            }

            @Override
            public Iterator<TypedValue<?>> split(String expression) {
                return this.resolveSessionForLanguage(sessions, expression).split(expression);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression) throws ExpressionExecutionException {
                return this.resolveSessionForLanguage(sessions, expression.expression()).evaluate(expression);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, DataType expectedOutputType) throws ExpressionExecutionException {
                return this.resolveSessionForLanguage(sessions, expression.expression()).evaluate(expression, expectedOutputType);
            }

            @Override
            public TypedValue<?> evaluate(CompiledExpression expression, long timeout) throws ExpressionExecutionException {
                return this.resolveSessionForLanguage(sessions, expression.expression()).evaluate(expression, timeout);
            }

            @Override
            public TypedValue<?> evaluateLogExpression(CompiledExpression expression) throws ExpressionExecutionException {
                return this.resolveSessionForLanguage(sessions, expression.expression()).evaluateLogExpression(expression);
            }

            @Override
            public Iterator<TypedValue<?>> split(CompiledExpression expression) {
                return this.resolveSessionForLanguage(sessions, expression.expression()).split(expression);
            }

            protected ExpressionLanguageSessionAdaptor resolveSessionForLanguage(Map<String, ExpressionLanguageSessionAdaptor> sessions2, String expression) {
                ExpressionLanguageSessionAdaptor elSession = sessions2.get(ExpressionLanguageAdaptorHandler.this.resolveLanguagePrefix(expression));
                if (elSession == null) {
                    throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage("This sessions was not created with an event, so '" + ExpressionLanguageAdaptorHandler.this.resolveLanguagePrefix(expression) + "' languge cannot be used in this session."));
                }
                return elSession;
            }

            @Override
            public void close() {
                sessions.values().forEach(es -> es.close());
            }
        };
    }

    private String resolveLanguagePrefix(String expression) {
        String languagePrefix = this.getLanguagePrefix(expression);
        if (StringUtils.isEmpty(languagePrefix)) {
            if (this.isMelDefault()) {
                return "mel";
            }
            return "dw";
        }
        if (this.expressionLanguages.size() == 1) {
            return this.expressionLanguages.keySet().iterator().next();
        }
        return languagePrefix;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.expressionLanguages.toString() + "]";
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.expressionLanguages.values());
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.expressionLanguages.values(), LOGGER);
    }
}

