/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;

public class IsolateCurrentTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private ExecutionInterceptor<T> next;
    private TransactionConfig transactionConfig;

    public IsolateCurrentTransactionInterceptor(ExecutionInterceptor<T> nextProcessingInterceptor, TransactionConfig transactionConfig) {
        this.next = nextProcessingInterceptor;
        this.transactionConfig = transactionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T execute(ExecutionCallback<T> muleEventProcessingCallback, ExecutionContext executionContext) throws Exception {
        boolean transactionIsolated = false;
        try {
            Transaction transaction;
            if (this.transactionConfig.getAction() == 7 && (transaction = TransactionCoordination.getInstance().getTransaction()) != null) {
                TransactionCoordination.getInstance().isolateTransaction();
                transactionIsolated = true;
            }
            T t2 = this.next.execute(muleEventProcessingCallback, executionContext);
            return t2;
        }
        finally {
            if (transactionIsolated) {
                TransactionCoordination.getInstance().restoreIsolatedTransaction();
            }
        }
    }
}

