/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.core.internal.lock.LockGroup;
import org.mule.runtime.core.internal.lock.LockProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceLockGroup
implements LockGroup {
    private static final long DEFAULT_LOCK_GROUP_SHUTDOWN_TIMEOUT = 5000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceLockGroup.class);
    private final Map<String, LockEntry> locks;
    private final Object lockAccessMonitor = new Object();
    private final LockProvider lockProvider;
    private final long gracefulShutdownTimeoutMillis;

    public InstanceLockGroup(LockProvider lockProvider, long shutdownTimeoutMillis) {
        this.lockProvider = lockProvider;
        this.locks = new HashMap<String, LockEntry>();
        this.gracefulShutdownTimeoutMillis = shutdownTimeoutMillis;
    }

    public InstanceLockGroup(LockProvider lockProvider) {
        this(lockProvider, 5000L);
    }

    @Override
    public void lock(String lockId) {
        LockEntry lockEntry = this.getOrCreateLockEntry(lockId);
        lockEntry.getLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(String key) {
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            LockEntry lockEntry = this.locks.get(key);
            if (lockEntry != null) {
                lockEntry.getLock().unlock();
                this.releaseLockEntry(key, lockEntry);
            } else {
                LOGGER.warn("Trying to unlock a lock with id {} that wasn't previously locked", (Object)key);
            }
        }
    }

    @Override
    public boolean tryLock(String lockId, long timeout, TimeUnit timeUnit) throws InterruptedException {
        LockEntry lockEntry = this.getOrCreateLockEntry(lockId);
        try {
            boolean lockAcquired = lockEntry.getLock().tryLock(timeout, timeUnit);
            if (!lockAcquired) {
                this.releaseLockEntry(lockId, lockEntry);
            }
            return lockAcquired;
        }
        catch (InterruptedException interruptedException) {
            this.releaseLockEntry(lockId, lockEntry);
            throw interruptedException;
        }
    }

    @Override
    public boolean tryLock(String lockId) {
        LockEntry lockEntry = this.getOrCreateLockEntry(lockId);
        boolean lockAcquired = lockEntry.getLock().tryLock();
        if (!lockAcquired) {
            this.releaseLockEntry(lockId, lockEntry);
        }
        return lockAcquired;
    }

    @Override
    public void lockInterruptibly(String lockId) throws InterruptedException {
        LockEntry lockEntry = this.getOrCreateLockEntry(lockId);
        try {
            lockEntry.getLock().lockInterruptibly();
        }
        catch (InterruptedException e) {
            this.releaseLockEntry(lockId, lockEntry);
            throw e;
        }
    }

    int size() {
        return this.locks.size();
    }

    @Override
    public void dispose() {
        this.waitForLocksToBeUnlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockEntry getOrCreateLockEntry(String lockId) {
        LockEntry lockEntry;
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            if (this.locks.containsKey(lockId)) {
                lockEntry = this.locks.get(lockId);
            } else {
                lockEntry = new LockEntry(this.lockProvider.createLock(lockId));
                this.locks.put(lockId, lockEntry);
            }
            lockEntry.incrementLockCount();
        }
        return lockEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockEntry(String lockId, LockEntry lockEntry) {
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            lockEntry.decrementLockCount();
            if (!lockEntry.hasPendingLocks()) {
                this.locks.remove(lockId);
                if (this.locks.isEmpty()) {
                    this.lockAccessMonitor.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLocksToBeUnlocked() {
        long timeOutMillis = System.currentTimeMillis() + this.gracefulShutdownTimeoutMillis;
        Object object = this.lockAccessMonitor;
        synchronized (object) {
            try {
                long remainingMillis = timeOutMillis - System.currentTimeMillis();
                while (!this.locks.isEmpty() && remainingMillis > 0L) {
                    this.lockAccessMonitor.wait(remainingMillis);
                    remainingMillis = timeOutMillis - System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.locks.isEmpty()) {
                LOGGER.warn("These locks weren't unlocked before disposing its lock group: {}", (Object)this.locks.keySet());
            }
        }
    }

    public static class LockEntry {
        private final AtomicInteger lockCount = new AtomicInteger(0);
        private final Lock lock;

        public LockEntry(Lock lock) {
            this.lock = lock;
        }

        public Lock getLock() {
            return this.lock;
        }

        public void incrementLockCount() {
            this.lockCount.incrementAndGet();
        }

        public void decrementLockCount() {
            this.lockCount.decrementAndGet();
        }

        public boolean hasPendingLocks() {
            return this.lockCount.get() > 0;
        }
    }
}

