/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.internal.lock.LockGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockAdapter
implements Lock {
    private static final boolean CHECK_LOCKABLE = Boolean.getBoolean(LockAdapter.class.getName() + ".CHECK_LOCKABLE");
    private static final Logger LOGGER = LoggerFactory.getLogger(LockAdapter.class);
    private LockGroup lockGroup;
    private String lockId;
    private SchedulerService schedulerService;

    public LockAdapter(String lockId, LockGroup lockGroup, SchedulerService schedulerService) {
        this.lockGroup = lockGroup;
        this.lockId = lockId;
        this.schedulerService = schedulerService;
    }

    @Override
    public void lock() {
        this.checkLockableThread();
        this.lockGroup.lock(this.lockId);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.checkLockableThread();
        this.lockGroup.lockInterruptibly(this.lockId);
    }

    private void checkLockableThread() {
        if (CHECK_LOCKABLE && this.schedulerService.isCurrentThreadForCpuWork()) {
            LOGGER.warn("About to lock current thread, which is not waitAllowed. Either dispatch the work to a waitAllowed Scheduler or use `tryLock`", new NonWaitAllowedThreadBlocked());
        }
    }

    @Override
    public boolean tryLock() {
        return this.lockGroup.tryLock(this.lockId);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.lockGroup.tryLock(this.lockId, timeout, timeUnit);
    }

    @Override
    public void unlock() {
        this.lockGroup.unlock(this.lockId);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException("Operation not supported by mule locks");
    }

    private static class NonWaitAllowedThreadBlocked
    extends RuntimeException {
        private static final long serialVersionUID = 123139630158524821L;

        public NonWaitAllowedThreadBlocked() {
            super("An exception is logged so the stack trace that leads to this situation can be traced.");
        }
    }
}

