/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.mule.runtime.core.api.management.stats.ArtifactMeterProvider;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;
import org.mule.runtime.metrics.api.meter.Meter;

public class DefaultFlowsSummaryStatistics
implements FlowsSummaryStatistics {
    private static final String APIKIT_FLOWNAME_REGEX = "(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final String APIKIT_SOAP_FLOWNAME_REGEX = "(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)";
    private static final Pattern APIKIT_FLOWNAME_PATTERN = Pattern.compile("(\\w*):(\\\\[^:]*)(:[^:]*)?:([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final Pattern APIKIT_SOAP_FLOWNAME_PATTERN = Pattern.compile("(\\w*):\\\\([^\\/\\\\\\[\\\\\\]\\{\\}#]*)");
    private static final long serialVersionUID = 1L;
    public static final String FLOWS_SUMMARY_APP_STATISTICS_NAME = "flows-summary-statistic";
    public static final String FLOWS_SUMMARY_APP_STATISTICS_DESCRIPTION_TEMPLATE = "Flow summary statistics";
    public static final String DECLARED_PRIVATE_FLOWS_APP_NAME = "declared-private-flows";
    public static final String DECLARED_PRIVATE_FLOWS_APP_DESCRIPTION = "Declared Private Flows";
    public static final String ACTIVE_PRIVATE_FLOWS_APP_NAME = "active-private-flows";
    public static final String ACTIVE_PRIVATE_FLOWS_APP_DESCRIPTION = "Activate Private Flows";
    public static final String DECLARED_TRIGGER_FLOWS_APP_NAME = "declared-trigger-flows";
    public static final String DECLARED_TRIGGER_FLOWS_APP_DESCRIPTION = "Declared Trigger Flows";
    public static final String ACTIVE_TRIGGER_FLOWS_NAME = "active-trigger-flows";
    public static final String ACTIVE_TRIGGER_FLOWS_DESCRIPTION = "Active Trigger Flows";
    public static final String DECLARED_APIKIT_FLOWS_APP_NAME = "declared-apikit-flows";
    public static final String DECLARED_APIKIT_FLOWS_APP_DESCRIPTION = "Declared ApiKit Flows";
    public static final String ACTIVE_APIKIT_FLOWS_APP_NAME = "active-apikit-flows";
    public static final String ACTIVE_APIKIT_FLOWS_APP_DESCRIPTION = "Active Apikit Flows";
    private final boolean enabled;
    private final AtomicInteger declaredPrivateFlows = new AtomicInteger(0);
    private final AtomicInteger activePrivateFlows = new AtomicInteger(0);
    private final AtomicInteger declaredTriggerFlows = new AtomicInteger(0);
    private final AtomicInteger activeTriggerFlows = new AtomicInteger(0);
    private final AtomicInteger declaredApikitFlows = new AtomicInteger(0);
    private final AtomicInteger activeApikitFlows = new AtomicInteger(0);

    public DefaultFlowsSummaryStatistics(boolean isStatisticsEnabled) {
        this.enabled = isStatisticsEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int incrementDeclaredPrivateFlow() {
        return this.declaredPrivateFlows.incrementAndGet();
    }

    public int incrementActivePrivateFlow() {
        return this.activePrivateFlows.incrementAndGet();
    }

    public int incrementDeclaredTriggerFlow() {
        return this.declaredTriggerFlows.incrementAndGet();
    }

    public int incrementActiveTriggerFlow() {
        return this.activeTriggerFlows.incrementAndGet();
    }

    public int incrementDeclaredApikitFlow() {
        return this.declaredApikitFlows.incrementAndGet();
    }

    public int incrementActiveApikitFlow() {
        return this.activeApikitFlows.incrementAndGet();
    }

    public int decrementActiveTriggerFlow() {
        return this.activeTriggerFlows.decrementAndGet();
    }

    public int decrementActivePrivateFlow() {
        return this.activePrivateFlows.decrementAndGet();
    }

    public int decrementActiveApikitFlow() {
        return this.activeApikitFlows.decrementAndGet();
    }

    public int decrementDeclaredPrivateFlow() {
        return this.declaredPrivateFlows.decrementAndGet();
    }

    public int decrementDeclaredTriggerFlow() {
        return this.declaredTriggerFlows.decrementAndGet();
    }

    public int decrementDeclaredApikitFlow() {
        return this.declaredApikitFlows.decrementAndGet();
    }

    @Override
    public int getDeclaredPrivateFlows() {
        return this.declaredPrivateFlows.get();
    }

    @Override
    public int getActivePrivateFlows() {
        return this.activePrivateFlows.get();
    }

    @Override
    public int getDeclaredTriggerFlows() {
        return this.declaredTriggerFlows.get();
    }

    @Override
    public int getActiveTriggerFlows() {
        return this.activeTriggerFlows.get();
    }

    @Override
    public int getDeclaredApikitFlows() {
        return this.declaredApikitFlows.get();
    }

    @Override
    public int getActiveApikitFlows() {
        return this.activeApikitFlows.get();
    }

    public static boolean isApiKitFlow(String flowName) {
        return APIKIT_FLOWNAME_PATTERN.matcher(flowName).matches() || APIKIT_SOAP_FLOWNAME_PATTERN.matcher(flowName).matches();
    }

    @Override
    public void trackUsingMeterProvider(ArtifactMeterProvider meterProvider) {
        String artifactId = meterProvider.getArtifactId();
        Meter meter = meterProvider.getMeterBuilder(FLOWS_SUMMARY_APP_STATISTICS_NAME).withDescription(FLOWS_SUMMARY_APP_STATISTICS_DESCRIPTION_TEMPLATE).withMeterAttribute("mule.artifact.id", artifactId).build();
        meter.counterBuilder(DECLARED_PRIVATE_FLOWS_APP_NAME).withValueSupplier(() -> this.declaredPrivateFlows.get()).withConsumerForAddOperation(value -> this.declaredPrivateFlows.addAndGet(value.intValue())).withSupplierForIncrementAndGetOperation(() -> this.declaredPrivateFlows.incrementAndGet()).withDescription(DECLARED_PRIVATE_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(ACTIVE_PRIVATE_FLOWS_APP_NAME).withValueSupplier(() -> this.activePrivateFlows.get()).withConsumerForAddOperation(value -> this.activePrivateFlows.addAndGet(value.intValue())).withSupplierForIncrementAndGetOperation(() -> this.activePrivateFlows.incrementAndGet()).withDescription(ACTIVE_PRIVATE_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(DECLARED_TRIGGER_FLOWS_APP_NAME).withValueSupplier(() -> this.declaredTriggerFlows.get()).withConsumerForAddOperation(value -> this.declaredTriggerFlows.addAndGet(value.intValue())).withSupplierForIncrementAndGetOperation(() -> this.declaredTriggerFlows.incrementAndGet()).withDescription(DECLARED_TRIGGER_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(ACTIVE_TRIGGER_FLOWS_NAME).withValueSupplier(() -> this.activeTriggerFlows.get()).withConsumerForAddOperation(value -> this.activeTriggerFlows.addAndGet(value.intValue())).withSupplierForIncrementAndGetOperation(() -> this.activeTriggerFlows.incrementAndGet()).withDescription(ACTIVE_TRIGGER_FLOWS_DESCRIPTION).build();
        meter.counterBuilder(DECLARED_APIKIT_FLOWS_APP_NAME).withValueSupplier(() -> this.declaredApikitFlows.get()).withConsumerForAddOperation(value -> this.declaredApikitFlows.addAndGet(value.intValue())).withSupplierForIncrementAndGetOperation(() -> this.declaredApikitFlows.incrementAndGet()).withDescription(DECLARED_APIKIT_FLOWS_APP_DESCRIPTION).build();
        meter.counterBuilder(ACTIVE_APIKIT_FLOWS_APP_NAME).withValueSupplier(() -> this.activeApikitFlows.get()).withConsumerForAddOperation(value -> this.activeApikitFlows.addAndGet(value.intValue())).withSupplierForIncrementAndGetOperation(() -> this.activeApikitFlows.incrementAndGet()).withDescription(ACTIVE_APIKIT_FLOWS_APP_DESCRIPTION).build();
    }
}

