/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.message;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.message.PrivilegedError;
import org.mule.runtime.internal.exception.SuppressedMuleException;

public final class ErrorBuilder {
    private Throwable exception;
    private String description;
    private String detailedDescription;
    private Component failingComponent;
    private ErrorType errorType;
    private Message errorMessage;
    private List<Error> errors = Collections.emptyList();
    private List<Error> suppressedErrors = Collections.emptyList();

    public static ErrorBuilder builder() {
        return new ErrorBuilder();
    }

    public static ErrorBuilder builder(Throwable e) {
        return new ErrorBuilder(e);
    }

    public static ErrorBuilder builder(Error e) {
        return new ErrorBuilder(e);
    }

    private ErrorBuilder() {
    }

    private ErrorBuilder(Throwable e) {
        String exceptionDescription;
        Throwable cause;
        this.exception = cause = e;
        this.description = exceptionDescription = e.getMessage() != null ? e.getMessage() : "unknown description";
        this.detailedDescription = exceptionDescription;
        if (cause instanceof SuppressedMuleException) {
            this.exception = cause = ((SuppressedMuleException)e).unwrap();
            this.addSuppressedErrors((SuppressedMuleException)e);
            this.updateErrorDescription((SuppressedMuleException)e);
        } else {
            MuleException muleRoot = ExceptionHelper.getRootMuleException(cause);
            if (muleRoot != null) {
                this.addSuppressedErrors(muleRoot);
                this.updateErrorDescription(muleRoot);
            }
        }
        if (cause instanceof ErrorMessageAwareException) {
            this.errorMessage = ((ErrorMessageAwareException)((Object)cause)).getErrorMessage();
        }
        if (cause instanceof ComposedErrorException) {
            this.errors = ((ComposedErrorException)((Object)cause)).getErrors();
        }
    }

    private void updateErrorDescription(MuleException muleException) {
        MuleException muleRoot = muleException;
        List<MuleException> suppressedCauses = muleException.getExceptionInfo().getSuppressedCauses();
        if (!suppressedCauses.isEmpty()) {
            muleRoot = ExceptionHelper.getRootMuleException(suppressedCauses.get(suppressedCauses.size() - 1));
        }
        if (muleRoot.getMessage() != null) {
            this.description = muleRoot.getMessage();
        }
    }

    private void addSuppressedErrors(MuleException muleException) {
        List<MuleException> suppressedCauses = muleException.getExceptionInfo().getSuppressedCauses();
        if (!suppressedCauses.isEmpty()) {
            ArrayList<Error> suppressions = new ArrayList<Error>(suppressedCauses.size());
            for (MuleException suppressedException : suppressedCauses) {
                if (!(suppressedException instanceof MessagingException)) continue;
                ((MessagingException)suppressedException).getEvent().getError().ifPresent(error -> {
                    suppressions.add((Error)error);
                    if (!(muleException instanceof RetryPolicyExhaustedException)) {
                        this.exception = error.getCause();
                    }
                });
            }
            this.suppressedErrors = suppressions;
        }
    }

    private ErrorBuilder(Error e) {
        this.description = e.getDescription();
        this.detailedDescription = e.getDetailedDescription();
        this.exception = e.getCause();
        this.errorType = e.getErrorType();
        this.errorMessage = e.getErrorMessage();
        this.errors = e.getChildErrors();
        this.suppressedErrors = ((PrivilegedError)e).getSuppressedErrors();
    }

    public ErrorBuilder exception(Throwable exception) {
        this.exception = exception;
        return this;
    }

    public ErrorBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ErrorBuilder detailedDescription(String detailedDescription) {
        this.detailedDescription = detailedDescription;
        return this;
    }

    public ErrorBuilder errorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public ErrorBuilder failingComponent(Component failingComponent) {
        this.failingComponent = failingComponent;
        return this;
    }

    public ErrorBuilder errorMessage(Message errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public ErrorBuilder errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public Error build() {
        Preconditions.checkState(this.exception != null, "exception cannot be null");
        Preconditions.checkState(this.description != null, "description cannot be null");
        Preconditions.checkState(this.detailedDescription != null, "detailedDescription cannot be null");
        Preconditions.checkState(this.errorType != null, "errorType cannot be null");
        return new DeserializableErrorImplementation(this.exception, this.description, this.detailedDescription, this.failingComponent, this.errorType, this.errorMessage, this.errors, this.suppressedErrors);
    }

    public static final class DeserializableErrorImplementation
    implements PrivilegedError {
        private static final long serialVersionUID = 6703483143042822990L;
        private final Throwable exception;
        private final String description;
        private final String detailedDescription;
        private final String failingComponent;
        private final ErrorType errorType;
        private final Message muleMessage;
        private final List<Error> errors;
        private final List<Error> suppressedErrors;
        private final String dslSource;

        private DeserializableErrorImplementation(Throwable exception, String description, String detailedDescription, Component failingComponent, ErrorType errorType, Message errorMessage, List<Error> errors, List<Error> suppressedErrors) {
            this.exception = exception;
            this.description = description;
            this.detailedDescription = detailedDescription;
            this.failingComponent = failingComponent != null ? failingComponent.getRepresentation() : null;
            this.errorType = errorType;
            this.muleMessage = errorMessage;
            this.errors = Collections.unmodifiableList(errors);
            this.suppressedErrors = Collections.unmodifiableList(suppressedErrors);
            this.dslSource = failingComponent != null ? failingComponent.getDslSource() : null;
        }

        @Override
        public String getDslSource() {
            return this.dslSource;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDetailedDescription() {
            return this.detailedDescription;
        }

        @Override
        public String getFailingComponent() {
            return this.failingComponent;
        }

        @Override
        public ErrorType getErrorType() {
            return this.errorType;
        }

        @Override
        public Throwable getCause() {
            return this.exception;
        }

        public Throwable getException() {
            return this.exception;
        }

        @Override
        public Message getErrorMessage() {
            return this.muleMessage;
        }

        @Override
        public List<Error> getChildErrors() {
            return this.errors;
        }

        @Override
        public List<Error> getSuppressedErrors() {
            return this.suppressedErrors;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(120);
            buf.append(System.lineSeparator());
            buf.append(this.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("{");
            buf.append(System.lineSeparator());
            buf.append("  description=").append(this.description);
            buf.append(System.lineSeparator());
            buf.append("  detailedDescription=").append(this.detailedDescription);
            buf.append(System.lineSeparator());
            buf.append("  errorType=").append(this.errorType);
            buf.append(System.lineSeparator());
            buf.append("  cause=").append(this.exception.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("  errorMessage=").append((Object)ObjectUtils.defaultIfNull(this.muleMessage, "-"));
            buf.append(System.lineSeparator());
            buf.append("  suppressedErrors=").append(this.suppressedErrors);
            buf.append(System.lineSeparator());
            buf.append("  childErrors=").append(this.errors);
            buf.append(System.lineSeparator());
            buf.append('}');
            return buf.toString();
        }
    }

    @Deprecated
    static final class ErrorImplementation
    implements PrivilegedError {
        private static final long serialVersionUID = -6904692174522094021L;
        private final Throwable exception;
        private final String description;
        private final String detailedDescription;
        private final Component failingComponent;
        private final ErrorType errorType;
        private final Message muleMessage;
        private final List<Error> errors;
        private final List<Error> suppressedErrors;

        private Object readResolve() throws ObjectStreamException {
            return ErrorBuilder.builder(this).build();
        }

        ErrorImplementation(Throwable exception, String description, String detailedDescription, Component failingComponent, ErrorType errorType, Message errorMessage, List<Error> errors, List<Error> suppressedErrors) {
            this.exception = exception;
            this.description = description;
            this.detailedDescription = detailedDescription;
            this.failingComponent = failingComponent;
            this.errorType = errorType;
            this.muleMessage = errorMessage;
            this.errors = Collections.unmodifiableList(errors);
            this.suppressedErrors = Collections.unmodifiableList(suppressedErrors);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDetailedDescription() {
            return this.detailedDescription;
        }

        @Override
        public String getFailingComponent() {
            return this.failingComponent != null ? this.failingComponent.getRepresentation() : null;
        }

        @Override
        public ErrorType getErrorType() {
            return this.errorType;
        }

        @Override
        public Throwable getCause() {
            return this.exception;
        }

        @Override
        public Message getErrorMessage() {
            return this.muleMessage;
        }

        @Override
        public List<Error> getChildErrors() {
            return this.errors;
        }

        @Override
        public List<Error> getSuppressedErrors() {
            return this.suppressedErrors;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(120);
            buf.append(System.lineSeparator());
            buf.append(this.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("{");
            buf.append(System.lineSeparator());
            buf.append("  description=").append(this.description);
            buf.append(System.lineSeparator());
            buf.append("  detailedDescription=").append(this.detailedDescription);
            buf.append(System.lineSeparator());
            buf.append("  errorType=").append(this.errorType);
            buf.append(System.lineSeparator());
            buf.append("  cause=").append(this.exception.getClass().getName());
            buf.append(System.lineSeparator());
            buf.append("  errorMessage=").append((Object)ObjectUtils.defaultIfNull(this.muleMessage, "-"));
            buf.append(System.lineSeparator());
            buf.append("  suppressedErrors=").append(this.suppressedErrors);
            buf.append(System.lineSeparator());
            buf.append("  childErrors=").append(this.errors);
            buf.append(System.lineSeparator());
            buf.append('}');
            return buf.toString();
        }
    }
}

