/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.function.LongConsumer;
import org.mule.runtime.core.api.event.CoreEvent;
import reactor.core.Disposable;
import reactor.core.publisher.FluxSink;
import reactor.util.context.Context;

public class FluxSinkWrapper
implements FluxSink<CoreEvent> {
    private final FluxSink<CoreEvent> sink;
    private boolean isBeingUsed;

    public FluxSinkWrapper(FluxSink<CoreEvent> sink) {
        this.sink = sink;
    }

    @Override
    public FluxSink<CoreEvent> next(CoreEvent coreEvent) {
        this.isBeingUsed = true;
        try {
            FluxSink<CoreEvent> fluxSink = this.sink.next(coreEvent);
            return fluxSink;
        }
        finally {
            this.isBeingUsed = false;
        }
    }

    @Override
    public void complete() {
        this.sink.complete();
    }

    @Override
    public void error(Throwable e) {
        this.sink.error(e);
    }

    @Override
    public Context currentContext() {
        return this.sink.currentContext();
    }

    @Override
    public long requestedFromDownstream() {
        return this.sink.requestedFromDownstream();
    }

    @Override
    public boolean isCancelled() {
        return this.sink.isCancelled();
    }

    @Override
    public FluxSink<CoreEvent> onRequest(LongConsumer consumer) {
        return this.sink.onRequest(consumer);
    }

    @Override
    public FluxSink<CoreEvent> onCancel(Disposable d) {
        return this.sink.onCancel(d);
    }

    @Override
    public FluxSink<CoreEvent> onDispose(Disposable d) {
        return this.sink.onDispose(d);
    }

    FluxSink<CoreEvent> getDelegate() {
        return this.sink;
    }

    public boolean isBeingUsed() {
        return this.isBeingUsed;
    }
}

