/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.context;

import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.api.tx.TransactionType;

public class DefaultTransactionProfilingEventContext
implements TransactionProfilingEventContext {
    private final Optional<ComponentLocation> originalLocation;
    private final ComponentLocation currentLocation;
    private final TransactionType type;
    private final long profilingTimestamp;

    public DefaultTransactionProfilingEventContext(Optional<ComponentLocation> originatingLocation, ComponentLocation currentLocation, TransactionType type, long profilingTimestamp) {
        this.originalLocation = originatingLocation;
        this.currentLocation = currentLocation;
        this.type = type;
        this.profilingTimestamp = profilingTimestamp;
    }

    @Override
    public long getTriggerTimestamp() {
        return this.profilingTimestamp;
    }

    @Override
    public TransactionType getType() {
        return this.type;
    }

    @Override
    public String getTransactionOriginatingLocation() {
        return this.originalLocation.map(location -> location.getLocation()).orElse(null);
    }

    @Override
    public ComponentLocation getEventOrginatingLocation() {
        return this.currentLocation;
    }
}

