/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.retry.async.AsynchronousRetryTemplate;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;

public class DefaultReconnectionConfig
extends AbstractComponent
implements ReconnectionConfig {
    public static final String DISABLE_ASYNC_RETRY_POLICY_ON_SOURCES = "mule.disableAsyncRetryPolicyOnSources";
    private final boolean failsDeployment;
    private final RetryPolicyTemplate retryPolicyTemplate;

    public DefaultReconnectionConfig(boolean failsDeployment, RetryPolicyTemplate retryPolicyTemplate) {
        this.failsDeployment = failsDeployment;
        this.retryPolicyTemplate = this.getRetryPolicyTemplate(retryPolicyTemplate);
    }

    @Override
    public boolean isFailsDeployment() {
        return this.failsDeployment;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate(RetryPolicyTemplate delegate) {
        if (delegate == null) {
            return this.retryPolicyTemplate;
        }
        if (this.failsDeployment) {
            return this.getBlockingTemplate(delegate);
        }
        if (this.isDisableAsyncReconnection()) {
            return this.getBlockingTemplate(delegate);
        }
        return this.getAsyncTemplate(delegate);
    }

    private boolean isDisableAsyncReconnection() {
        return Boolean.valueOf(System.getProperty(DISABLE_ASYNC_RETRY_POLICY_ON_SOURCES, "false"));
    }

    private RetryPolicyTemplate getAsyncTemplate(RetryPolicyTemplate delegate) {
        if (delegate instanceof AsynchronousRetryTemplate) {
            return delegate;
        }
        return new AsynchronousRetryTemplate(delegate);
    }

    private RetryPolicyTemplate getBlockingTemplate(RetryPolicyTemplate delegate) {
        if (delegate == null) {
            return this.retryPolicyTemplate;
        }
        if (delegate instanceof AsynchronousRetryTemplate) {
            return this.getBlockingTemplate(((AsynchronousRetryTemplate)delegate).getDelegate());
        }
        return delegate;
    }
}

