/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.security.tls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.mule.runtime.core.internal.security.tls.TlsPropertiesMapper;
import org.mule.runtime.core.privileged.security.tls.TlsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsPropertiesSocketFactory
extends SSLSocketFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean anon;
    private String namespace;
    private SSLSocketFactory factory;

    public TlsPropertiesSocketFactory(boolean anon2, String namespace) {
        this.logger.debug("creating: " + anon2 + "; " + namespace);
        this.anon = anon2;
        this.namespace = namespace;
    }

    private synchronized SSLSocketFactory getFactory() throws IOException {
        if (null == this.factory) {
            this.logger.debug("creating factory");
            TlsPropertiesMapper propertiesMapper = new TlsPropertiesMapper(this.namespace);
            TlsConfiguration configuration = new TlsConfiguration(".keystore");
            propertiesMapper.readFromProperties(configuration, System.getProperties());
            try {
                configuration.initialise(this.anon, this.namespace);
                this.factory = configuration.getSocketFactory();
            }
            catch (Exception e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        return this.factory;
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        return this.getFactory().createSocket(s2, host, port, autoClose);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        try {
            return this.getFactory().getDefaultCipherSuites();
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        try {
            return this.getFactory().getSupportedCipherSuites();
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        return this.getFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.getFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.getFactory().createSocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.getFactory().createSocket(address, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.getFactory().createSocket();
    }
}

