/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.AbstractStreamingBuffer;
import org.mule.runtime.core.internal.streaming.bytes.InputStreamBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputStreamBuffer
extends AbstractStreamingBuffer
implements InputStreamBuffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInputStreamBuffer.class);
    protected final InputStream stream;
    protected final ByteBufferManager bufferManager;
    protected boolean streamFullyConsumed = false;

    public AbstractInputStreamBuffer(InputStream stream, ByteBufferManager bufferManager) {
        this.stream = stream;
        this.bufferManager = bufferManager;
    }

    public abstract int consumeForwardData() throws IOException;

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.writeLock.lock();
            try {
                this.doClose();
            }
            finally {
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (IOException e) {
                        LOGGER.debug("Found exception trying to close InputStream", e);
                    }
                }
                this.writeLock.unlock();
            }
        }
    }

    public abstract void doClose();

    @Override
    public final ByteBuffer get(long position, int length) {
        Preconditions.checkState(!this.closed.get(), "Buffer is closed");
        return this.doGet(position, length);
    }

    protected abstract ByteBuffer doGet(long var1, int var3);

    protected int consumeStream(ByteBuffer buffer) throws IOException {
        byte[] dest = buffer.array();
        int totalRead = 0;
        int remaining = buffer.remaining();
        int offset = buffer.position();
        while (remaining > 0) {
            try {
                if (totalRead > 0 && this.stream.available() < 1) break;
                int read = this.stream.read(dest, offset, remaining);
                if (read == -1) {
                    this.streamFullyConsumed = true;
                    if (totalRead != 0) break;
                    return -1;
                }
                if (read == 0) break;
                totalRead += read;
                remaining -= read;
                offset += read;
            }
            catch (IOException e) {
                if (!Thread.interrupted()) {
                    throw e;
                }
                Thread.currentThread().interrupt();
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Thread {} interrupted while reading from stream.", (Object)Thread.currentThread().getName());
                }
                if (totalRead == 0 || this.closed.get()) {
                    this.streamFullyConsumed = true;
                    return -1;
                }
                throw e;
            }
        }
        if (totalRead > 0) {
            buffer.position(offset);
        }
        return totalRead;
    }

    protected abstract ByteBuffer copy(long var1, int var3);
}

