/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.graph.TransformationEdge;
import org.mule.runtime.core.internal.transformer.graph.TransformationGraph;

public class SynchronizedTransformationGraph {
    private ReentrantReadWriteLock readWriteLock;
    private TransformationGraph transformationGraph = new TransformationGraph();

    public SynchronizedTransformationGraph() {
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public void addConverter(Converter converter) {
        this.readWriteLock.writeLock().lock();
        try {
            this.transformationGraph.addConverter(converter);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void removeConverter(Converter converter) {
        this.readWriteLock.writeLock().lock();
        try {
            this.transformationGraph.removeConverter(converter);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Set<TransformationEdge> outgoingEdgesOf(DataType vertex) {
        this.readWriteLock.readLock().lock();
        try {
            ImmutableSet<TransformationEdge> immutableSet = ImmutableSet.copyOf(this.transformationGraph.outgoingEdgesOf(vertex));
            return immutableSet;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public DataType getEdgeTarget(TransformationEdge transformationEdge) {
        this.readWriteLock.readLock().lock();
        try {
            DataType dataType = (DataType)this.transformationGraph.getEdgeTarget(transformationEdge);
            return dataType;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public boolean containsVertex(DataType dataType) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.transformationGraph.containsVertex(dataType);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    List<DataType> getSuperVertexes(DataType vertex) {
        this.readWriteLock.readLock().lock();
        try {
            ImmutableList<DataType> immutableList = ImmutableList.copyOf(this.transformationGraph.getSuperVertexes(vertex));
            return immutableList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    List<DataType> getSubVertexes(DataType vertex) {
        this.readWriteLock.readLock().lock();
        try {
            ImmutableList<DataType> immutableList = ImmutableList.copyOf(this.transformationGraph.getSubVertexes(vertex));
            return immutableList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    boolean containsVertexOrSuper(DataType vertex) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.transformationGraph.containsVertexOrSuper(vertex);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    boolean containsVertexOrSub(DataType vertex) {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.transformationGraph.containsVertexOrSub(vertex);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

