/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;

public class ObjectToOutputHandler
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ObjectToOutputHandler() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.registerSourceType(DataType.fromType(Serializable.class));
        this.setReturnDataType(DataType.fromType(OutputHandler.class));
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src instanceof String) {
            return (event, out) -> out.write(((String)src).getBytes(encoding));
        }
        if (src instanceof byte[]) {
            return (event, out) -> out.write((byte[])src);
        }
        if (src instanceof CursorStreamProvider) {
            return this.handleInputStream((InputStream)((CursorStreamProvider)src).openCursor());
        }
        if (src instanceof InputStream) {
            return this.handleInputStream((InputStream)src);
        }
        if (src instanceof Serializable) {
            return (event, out) -> this.muleContext.getObjectSerializer().getExternalProtocol().serialize(src, out);
        }
        throw new TransformerException(I18nMessageFactory.createStaticMessage("Unable to convert " + src.getClass() + " to OutputHandler."));
    }

    private OutputHandler handleInputStream(InputStream is) {
        return (event, out) -> {
            try {
                IOUtils.copyLarge(is, out);
            }
            finally {
                is.close();
            }
        };
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

