/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;

public class CopyOnWriteCaseInsensitiveMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -2753436627413265538L;
    private Map<K, V> core;
    private transient Map<K, V> view;
    private transient boolean requiresCopy;
    private transient Set<K> keyset = new KeySet();

    public CopyOnWriteCaseInsensitiveMap() {
        this.updateCore(new CaseInsensitiveHashMap());
    }

    public CopyOnWriteCaseInsensitiveMap(Map<K, V> that) {
        if (that instanceof CopyOnWriteCaseInsensitiveMap) {
            this.updateCore(((CopyOnWriteCaseInsensitiveMap)that).core);
        } else {
            this.updateCore(that);
        }
        this.requiresCopy = true;
    }

    public CopyOnWriteCaseInsensitiveMap<K, V> clone() {
        try {
            CopyOnWriteCaseInsensitiveMap<K, V> copyOnWriteCaseInsensitiveMap = new CopyOnWriteCaseInsensitiveMap<K, V>(this);
            return copyOnWriteCaseInsensitiveMap;
        }
        finally {
            this.requiresCopy = true;
        }
    }

    private void copy() {
        if (this.requiresCopy) {
            this.updateCore(new CaseInsensitiveHashMap(this.core));
            this.requiresCopy = false;
        }
    }

    @Override
    public int size() {
        return this.core.size();
    }

    @Override
    public boolean isEmpty() {
        return this.core.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.core.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.core.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.core.get(key);
    }

    @Override
    public V put(K key, V value) {
        this.copy();
        return this.core.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.copy();
        return this.core.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t2) {
        this.copy();
        this.core.putAll(t2);
    }

    @Override
    public void clear() {
        this.updateCore(new CaseInsensitiveHashMap());
    }

    @Override
    public Set<K> keySet() {
        return this.keyset;
    }

    public Map<K, V> asHashMap() {
        return new HashMap<K, V>(this.view);
    }

    @Override
    public Collection<V> values() {
        return this.view.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.view.entrySet();
    }

    public String toString() {
        return this.core.toString();
    }

    private void updateCore(Map<K, V> core) {
        this.core = core;
        this.view = Collections.unmodifiableMap(core);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.view = Collections.unmodifiableMap(this.core);
        this.keyset = new KeySet();
    }

    private final class KeyIterator
    implements Iterator<K> {
        private int current;
        private int lastRemovalIndex;
        private K[] keyArray;

        public KeyIterator() {
            this.lastRemovalIndex = this.current = -1;
            this.keyArray = CopyOnWriteCaseInsensitiveMap.this.core.keySet().toArray();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.keyArray.length - 1;
        }

        @Override
        public K next() {
            try {
                return this.keyArray[++this.current];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.current == -1) {
                throw new IllegalStateException("Cannot remove element before first invoking next()");
            }
            if (this.current == this.lastRemovalIndex) {
                throw new IllegalStateException("Remove can only be called once per call to next()");
            }
            CopyOnWriteCaseInsensitiveMap.this.remove(this.keyArray[this.current]);
            this.lastRemovalIndex = this.current;
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return CopyOnWriteCaseInsensitiveMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return CopyOnWriteCaseInsensitiveMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return CopyOnWriteCaseInsensitiveMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CopyOnWriteCaseInsensitiveMap.this.clear();
        }
    }
}

