/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.core.internal.util.collection.TransformingIterator;

public class TransformingCollection<T>
implements Collection<T> {
    private Collection<Object> delegate;
    protected final Class<T> targetType;
    protected final Function<Object, T> transformer;
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected boolean transformAllInvoked = false;

    public TransformingCollection(Collection<Object> delegate, Function<Object, T> transformer) {
        this(delegate, transformer, null);
    }

    public TransformingCollection(Collection<Object> delegate, Function<Object, T> transformer, Class<T> targetType) {
        this.delegate = delegate;
        this.targetType = targetType;
        this.transformer = targetType != null ? value -> this.isTargetInstance(value) ? value : transformer.apply(value) : transformer;
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.readLock.lock();
        try {
            boolean contains = this.delegate.contains(o);
            if (this.transformAllInvoked) {
                boolean bl = contains;
                return bl;
            }
            if (!contains && this.isTargetInstance(o)) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    contains = this.delegate.contains(o);
                    if (!contains) {
                        this.transformAll();
                    }
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
            }
            boolean bl = this.delegate.contains(o);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.transformAllInvoked ? this.delegate.iterator() : TransformingIterator.from(this.delegate.iterator(), this.transformer);
    }

    @Override
    public Object[] toArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.transformAllInvoked ? this.delegate.toArray() : this.transformArray(this.delegate.toArray());
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.readLock.lock();
        try {
            T[] TArray = this.transformAllInvoked ? this.delegate.toArray(a) : this.transformArray(this.delegate.toArray(a));
            return TArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private <T> T[] transformArray(T[] array) {
        return Stream.of(array).map(result -> this.transformer.apply(result)).toArray(Object[]::new);
    }

    @Override
    public boolean add(T o) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.add(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean remove(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.remove(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.readLock.lock();
        try {
            boolean bl = this.delegate.stream().allMatch(this.delegate::contains);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected <T> Collection<T> transformedCopy(Collection<?> items) {
        return items.stream().map(this.transformer::apply).collect(Collectors.toList());
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.addAll(c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.writeLock.lock();
        try {
            boolean removed = false;
            for (Object value : c) {
                boolean itemRemoved = this.delegate.remove(c);
                if (!itemRemoved) {
                    itemRemoved = this.delegate.remove(this.transformer.apply(value));
                }
                removed = removed || itemRemoved;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.delegate.removeIf((? super E result) -> filter.test((T)this.transformer.apply(result)));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(this.transformedCopy(c));
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean equals(Object o) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.equals(o);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int hashCode() {
        this.writeLock.lock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        if (this.transformAllInvoked) {
            return this.delegate.spliterator();
        }
        return this.stream().collect(Collectors.toList()).spliterator();
    }

    @Override
    public Stream<T> stream() {
        if (this.transformAllInvoked) {
            return this.delegate.stream();
        }
        return this.delegate.stream().map(this.transformer::apply);
    }

    @Override
    public Stream<T> parallelStream() {
        if (this.transformAllInvoked) {
            return this.delegate.parallelStream();
        }
        return this.delegate.parallelStream().map(this.transformer::apply);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.stream().forEach(action);
    }

    protected boolean isTargetInstance(Object o) {
        return this.targetType != null ? this.targetType.isInstance(o) : false;
    }

    protected void transformAll() {
        this.delegate = this.transformedCopy(this.delegate);
        this.transformAllInvoked = true;
    }
}

