/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import org.mule.runtime.core.internal.util.collection.ListIteratorAdapter;
import org.mule.runtime.core.internal.util.collection.TransformingCollection;

public class TransformingList<T>
extends TransformingCollection<T>
implements List<T> {
    private final List<Object> delegate;

    public TransformingList(List<Object> delegate, Function<Object, T> transformer) {
        super(delegate, transformer);
        this.delegate = delegate;
    }

    public TransformingList(List<Object> delegate, Function<Object, T> transformer, Class<T> targetType) {
        super(delegate, transformer, targetType);
        this.delegate = delegate;
    }

    @Override
    public void add(int index, T element) {
        this.writeLock.lock();
        try {
            this.delegate.add(index, element);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.writeLock.lock();
        try {
            boolean bl = this.delegate.addAll(index, c);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        this.readLock.lock();
        try {
            int i = this.delegate.indexOf(o);
            if (i == -1 && this.isTargetInstance(o)) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    i = this.delegate.indexOf(o);
                    if (i == -1) {
                        this.transformAll();
                    }
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
                i = this.delegate.indexOf(o);
            }
            int n = i;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        this.readLock.lock();
        try {
            int i = this.delegate.lastIndexOf(o);
            if (i == -1 && this.isTargetInstance(o)) {
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    i = this.delegate.lastIndexOf(o);
                    if (i == -1) {
                        this.transformAll();
                    }
                }
                finally {
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
                i = this.delegate.lastIndexOf(o);
            }
            int n = i;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.writeLock.lock();
        try {
            this.delegate.sort((o1, o2) -> c.compare((T)this.transformer.apply(o1), (T)this.transformer.apply(o2)));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        this.readLock.lock();
        try {
            Object update;
            block10: {
                Object object;
                Object value = this.delegate.get(index);
                if (this.isTargetInstance(value)) {
                    Object object2 = value;
                    return (T)object2;
                }
                this.readLock.unlock();
                this.writeLock.lock();
                try {
                    update = this.delegate.get(index);
                    if (!this.isTargetInstance(update)) break block10;
                    object = update;
                    this.readLock.lock();
                    this.writeLock.unlock();
                }
                catch (Throwable throwable) {
                    this.readLock.lock();
                    this.writeLock.unlock();
                    throw throwable;
                }
                return (T)object;
            }
            update = this.transformer.apply(update);
            this.delegate.set(index, update);
            Object object = update;
            this.readLock.lock();
            this.writeLock.unlock();
            return (T)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T item) {
        this.writeLock.lock();
        try {
            Object previous = this.delegate.set(index, item);
            T t2 = previous != null ? (T)this.transformer.apply(previous) : null;
            return t2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T remove(int index) {
        this.writeLock.lock();
        try {
            Object previous = this.delegate.remove(index);
            T t2 = previous != null ? (T)this.transformer.apply(previous) : null;
            return t2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ListIteratorAdapter(this);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ListIteratorAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        this.readLock.lock();
        try {
            List<Object> results = this.delegate.subList(fromIndex, toIndex);
            TransformingList<T> transformingList = new TransformingList<T>(results, this.transformer, this.targetType);
            return transformingList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    protected void transformAll() {
        for (int i = 0; i < this.delegate.size(); ++i) {
            Object value = this.delegate.get(i);
            this.delegate.set(i, this.transformer.apply(value));
        }
        this.transformAllInvoked = true;
    }
}

