/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.ExpressionLanguageSession;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.SynchronousSink;

public final class Operators {
    private Operators() {
    }

    public static BiConsumer<CoreEvent, SynchronousSink<CoreEvent>> nullSafeMap(Function<CoreEvent, CoreEvent> mapper) {
        return (event, sink) -> {
            try {
                if (event != null) {
                    CoreEvent result = (CoreEvent)mapper.apply((CoreEvent)event);
                    if (result != null) {
                        sink.next(result);
                    } else {
                        ((BaseEventContext)event.getContext()).success();
                    }
                }
            }
            catch (Exception e) {
                sink.error(e);
            }
        };
    }

    @Deprecated
    public static Function<CoreEvent, CoreEvent> outputToTarget(CoreEvent originalEvent, String target, String targetValueExpression, ExpressionLanguage expressionManager) {
        return result -> {
            if (target != null) {
                TypedValue<?> targetValue = expressionManager.evaluate(targetValueExpression, BindingContextUtils.getTargetBindingContext(result.getMessage()));
                return CoreEvent.builder(originalEvent).addVariable(target, targetValue).build();
            }
            return result;
        };
    }

    public static CoreEvent outputToTarget(CoreEvent originalEvent, CoreEvent result, String target, CompiledExpression targetValueExpression, ExpressionLanguage expressionLanguage) {
        if (target != null) {
            try (ExpressionLanguageSession session = expressionLanguage.openSession(BindingContextUtils.getTargetBindingContext(result.getMessage()));){
                TypedValue<?> targetValue = session.evaluate(targetValueExpression);
                CoreEvent coreEvent = CoreEvent.builder(originalEvent).addVariable(target, targetValue).build();
                return coreEvent;
            }
        }
        return result;
    }

    public static <T> Subscriber<T> requestUnbounded() {
        return RequestMaxSubscriber.INSTANCE;
    }

    static final class RequestMaxSubscriber<T>
    implements Subscriber<T> {
        static final RequestMaxSubscriber INSTANCE = new RequestMaxSubscriber();

        RequestMaxSubscriber() {
        }

        @Override
        public void onSubscribe(Subscription s2) {
            s2.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(Object o) {
        }

        @Override
        public void onError(Throwable t2) {
        }

        @Override
        public void onComplete() {
        }
    }
}

