/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.exception;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExceptionListener
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionListener.class);
    private static final String NOT_SET = "<not set>";
    private Logger logger = LOGGER;
    private NotificationDispatcher notificationFirer;
    private FlowConstructStatistics statistics;
    private String representation;

    @Override
    public final synchronized void initialise() throws InitialisationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initialising exception listener: " + this.toString());
        }
        if (this.representation == null) {
            this.representation = this.getClass().getSimpleName();
        }
    }

    private void fireNotification(Exception ex, CoreEvent event, ComponentLocation componentLocation) {
        if (ex.getCause() != null && this.getCause(ex) instanceof SecurityException) {
            this.fireNotification(new SecurityNotification((SecurityException)this.getCause(ex), 401));
        } else {
            Component component = null;
            if (ex instanceof MessagingException) {
                component = ((MessagingException)ex).getFailingComponent();
            }
            this.fireNotification(new ExceptionNotification(EnrichedNotificationInfo.createInfo(event, ex, component), componentLocation != null ? componentLocation : componentLocation));
        }
    }

    public void fireNotification(Exception ex, CoreEvent event) {
        this.fireNotification(ex, event, null);
    }

    private Throwable getCause(Exception ex) {
        return ex.getCause() instanceof TypedException ? ex.getCause().getCause() : ex.getCause();
    }

    public Pair<MuleException, String> resolveExceptionAndMessageToLog(Throwable t2) {
        MuleException muleException = ExceptionHelper.getRootMuleException(t2);
        String logMessage = null;
        if (muleException != null) {
            logMessage = !MuleException.isVerboseExceptions() && t2 instanceof EventProcessingException && ((EventProcessingException)t2).getEvent().getError().map(e -> Errors.CORE_NAMESPACE_NAME.equals(e.getErrorType().getNamespace()) && "UNKNOWN".equals(e.getErrorType().getIdentifier())).orElse(false) != false ? ((MuleException)ExceptionHelper.sanitize(muleException)).getVerboseMessage() : muleException.getDetailedMessage();
        }
        return new Pair<MuleException, String>(muleException, logMessage);
    }

    public boolean resolveAndLogException(Throwable t2) {
        Pair<MuleException, String> resolvedException = this.resolveExceptionAndMessageToLog(t2);
        if (resolvedException.getSecond() == null) {
            this.doLogException("Caught exception in Exception Strategy: " + t2.getMessage(), t2);
            return true;
        }
        if (resolvedException.getFirst().getExceptionInfo().isAlreadyLogged() && !(resolvedException.getFirst() instanceof FlowBackPressureException)) {
            return false;
        }
        this.doLogException(resolvedException.getSecond(), null);
        resolvedException.getFirst().getExceptionInfo().setAlreadyLogged(true);
        return true;
    }

    protected void doLogException(String message, Throwable t2) {
        if (t2 == null) {
            this.logger.error(message);
        } else {
            this.logger.error(message, t2);
        }
    }

    public void processStatistics() {
        if (this.statistics != null) {
            this.statistics.incExecutionError();
        }
    }

    protected void logFatal(CoreEvent event, Throwable t2) {
        if (this.statistics != null) {
            this.statistics.incFatalError();
        }
        String logUniqueId = StringUtils.defaultString(event.getCorrelationId(), NOT_SET);
        String printableLogMessage = MessageFormat.format("Message identification summary here: id={0}, correlation={1}", logUniqueId, event.getGroupCorrelation());
        this.logger.error("Failed to dispatch message to error queue after it failed to process.  This may cause message loss. " + (event.getMessage() == null ? "" : printableLogMessage), t2);
    }

    protected void fireNotification(Notification notification) {
        if (this.notificationFirer != null) {
            this.notificationFirer.dispatch(notification);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.debug("notificationFirer is not yet available for firing notifications, ignoring event: " + notification);
        }
    }

    public void setNotificationFirer(NotificationDispatcher notificationFirer) {
        this.notificationFirer = notificationFirer;
    }

    public void setStatistics(FlowConstructStatistics statistics) {
        this.statistics = statistics;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public String toString() {
        return this.representation;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

