/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ProcessorChainRouter
extends AbstractExecutableComponent
implements Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessorChainRouter.class);
    @Inject
    private MuleContext muleContext;
    private String name;
    private List<Processor> processors = Collections.emptyList();
    private MessageProcessorChain processorChain;

    @Override
    protected ReactiveProcessor getExecutableFunction() {
        return publisher -> Mono.from(publisher).transform(this.processorChain);
    }

    public void setProcessors(List processors) {
        this.processors = processors;
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processorChain);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.processorChain, LOGGER);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processorChain);
    }

    @Override
    public void initialise() throws InitialisationException {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.setName("processor chain '" + this.name + "'");
        for (Processor processor : this.processors) {
            if (processor instanceof Processor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        this.processorChain = builder.build();
        LifecycleUtils.initialiseIfNeeded(this.processorChain, this.muleContext);
    }
}

