/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.processor.Processor;

public class RoutingException
extends MuleException {
    private static final long serialVersionUID = 2478458847072048647L;
    protected final transient Processor route;

    public RoutingException(Processor route) {
        super(RoutingException.generateMessage(null, route));
        this.route = route;
    }

    public RoutingException(Processor route, Throwable cause) {
        super(RoutingException.generateMessage(null, route), cause);
        this.route = route;
    }

    public RoutingException(I18nMessage message, Processor route) {
        super(RoutingException.generateMessage(message, route));
        this.route = route;
    }

    public RoutingException(I18nMessage message, Processor route, Throwable cause) {
        super(RoutingException.generateMessage(message, route), cause);
        this.route = route;
    }

    public Processor getRoute() {
        return this.route;
    }

    private static I18nMessage generateMessage(I18nMessage message, Processor target) {
        I18nMessage m4 = CoreMessages.failedToRouterViaEndpoint(target);
        if (message != null) {
            message.setNextMessage(m4);
            return message;
        }
        return m4;
    }
}

