/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xml.parser;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.dsl.api.xml.parser.XmlGathererErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultXmlLoggerErrorHandler
implements XmlGathererErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultXmlLoggerErrorHandler.class);
    private List<SAXParseException> errors = new ArrayList<SAXParseException>();

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Found a waring exception parsing document, message '%s'", e.toString()), e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Found a fatal error exception parsing document, message '%s'", e.toString()), e);
        }
        throw e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Found error exception parsing document, message '%s'", e.toString()), e);
        }
        this.errors.add(e);
    }

    @Override
    public List<SAXParseException> getErrors() {
        return this.errors;
    }
}

