/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.handler.ObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.ClassValueModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.extension.api.annotation.ConfigReferences;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.extension.api.annotation.param.reference.FlowReference;
import org.mule.runtime.extension.api.annotation.param.reference.ObjectStoreReference;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.ConfigOverrideTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DefaultImplementingTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.DisplayTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.NullSafeTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.extension.internal.semantic.TypeSemanticTermsUtils;
import org.mule.sdk.api.annotation.dsl.xml.ParameterDsl;

final class ExtensionsObjectFieldHandler
implements ObjectFieldHandler {
    ExtensionsObjectFieldHandler() {
    }

    @Override
    public void handleFields(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (clazz.getName().equals(Chain.class.getName())) {
            return;
        }
        Collection<Field> fields = TypeUtils.getParameterFields(clazz);
        if (fields.isEmpty()) {
            this.validateIllegalAnnotationUseOnNonParameterFields(clazz);
            this.fallbackToBeanProperties(clazz, typeHandlerManager, context, builder);
            return;
        }
        for (Field field2 : fields) {
            ObjectFieldTypeBuilder fieldBuilder = builder.addField();
            fieldBuilder.key(JavaParserUtils.getAlias(field2));
            this.setOptionalAndDefault(field2, fieldBuilder);
            this.processParameterGroup(field2, fieldBuilder);
            this.processExpressionSupport(field2, fieldBuilder);
            this.processNullSafe(clazz, field2, fieldBuilder, typeHandlerManager, context);
            this.processElementStyle(field2, fieldBuilder);
            this.processLayoutAnnotation(field2, fieldBuilder);
            this.processDisplayAnnotation(field2, fieldBuilder);
            this.processConfigOverride(field2, fieldBuilder);
            this.processElementReference(field2, fieldBuilder);
            this.processSemanticTerms(field2, fieldBuilder);
            this.setFieldType(typeHandlerManager, context, field2, fieldBuilder);
        }
    }

    private void validateIllegalAnnotationUseOnNonParameterFields(Class<?> clazz) {
        String annotationsPackageName = Parameter.class.getPackage().getName();
        List illegalFieldNames = TypeUtils.getAllFields(clazz).stream().filter(field2 -> Stream.of(field2.getAnnotations()).anyMatch(a -> {
            Class<? extends Annotation> annotationType = a.annotationType();
            return annotationType.getName().contains(annotationsPackageName) && !annotationType.getSimpleName().equals(RefName.class.getSimpleName());
        })).map(Field::getName).collect(Collectors.toList());
        if (!illegalFieldNames.isEmpty()) {
            throw new IllegalModelDefinitionException(String.format("Class '%s' has fields which are not parameters but are annotated with Extensions API annotations. Illegal fields are " + illegalFieldNames, clazz.getName()));
        }
    }

    private void processParameterGroup(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        if (TypeUtils.isParameterGroup(field2)) {
            fieldBuilder.with(new FlattenedTypeAnnotation());
            this.processExclusiveOptionals(field2, fieldBuilder);
        }
    }

    private void processExclusiveOptionals(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        Optional<Boolean> exclusiveOptionalsIsOneRequired = JavaParserUtils.getExclusiveOptionalsIsOneRequired(field2.getType());
        if (exclusiveOptionalsIsOneRequired.isPresent()) {
            Set exclusiveParameters = TypeUtils.getParameterFields(field2.getType()).stream().filter(TypeUtils::isOptional).map(JavaParserUtils::getAlias).collect(Collectors.toCollection(LinkedHashSet::new));
            fieldBuilder.with(new ExclusiveOptionalsTypeAnnotation(exclusiveParameters, exclusiveOptionalsIsOneRequired.get()));
        }
    }

    private void processDisplayAnnotation(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        Optional<ClassValueModel> classValueModel;
        Optional<PathModel> pathModel;
        Optional<String> exampleValue;
        Optional<String> summaryValue;
        DisplayModel.DisplayModelBuilder builder = DisplayModel.builder();
        boolean shouldAddTypeAnnotation = false;
        Optional<String> displayName = TypeUtils.getDisplayName(field2);
        if (displayName.isPresent()) {
            builder.displayName(displayName.get());
            shouldAddTypeAnnotation = true;
        }
        if ((summaryValue = TypeUtils.getSummaryValue(field2)).isPresent()) {
            builder.summary(summaryValue.get());
            shouldAddTypeAnnotation = true;
        }
        if ((exampleValue = TypeUtils.getExampleValue(field2)).isPresent()) {
            builder.example(exampleValue.get());
            shouldAddTypeAnnotation = true;
        }
        if ((pathModel = TypeUtils.getPathModel(field2)).isPresent()) {
            builder.path(pathModel.get());
            shouldAddTypeAnnotation = true;
        }
        if ((classValueModel = TypeUtils.getClassValueModel(field2)).isPresent()) {
            builder.classValue(classValueModel.get());
            shouldAddTypeAnnotation = true;
        }
        if (shouldAddTypeAnnotation) {
            fieldBuilder.with(new DisplayTypeAnnotation(builder.build()));
        }
    }

    private void processLayoutAnnotation(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        LayoutModel.LayoutModelBuilder builder = LayoutModel.builder();
        boolean shouldAddTypeAnnotation = false;
        Optional<Pair<Integer, String>> value = TypeUtils.getPlacementValue(field2);
        if (value.isPresent()) {
            builder.tabName(value.get().getSecond()).order(value.get().getFirst());
            shouldAddTypeAnnotation = true;
        }
        if (TypeUtils.isPasswordField(field2)) {
            builder.asPassword();
            shouldAddTypeAnnotation = true;
        }
        if (TypeUtils.isTextField(field2)) {
            builder.asText();
            shouldAddTypeAnnotation = true;
        }
        if (TypeUtils.isQueryField(field2)) {
            builder.asQuery();
            shouldAddTypeAnnotation = true;
        }
        if (shouldAddTypeAnnotation) {
            fieldBuilder.with(new LayoutTypeAnnotation(builder.build()));
        }
    }

    private void setFieldType(TypeHandlerManager typeHandlerManager, ParsingContext context, Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        Type fieldType = field2.getGenericType();
        Optional<TypeBuilder<?>> typeBuilder = context.getTypeBuilder(fieldType);
        if (typeBuilder.isPresent()) {
            fieldBuilder.value(typeBuilder.get());
        } else {
            typeHandlerManager.handle(fieldType, context, fieldBuilder.value());
        }
    }

    private void processExpressionSupport(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        fieldBuilder.with(new ExpressionSupportAnnotation(JavaParserUtils.getExpressionSupport(field2).orElse(ExpressionSupport.SUPPORTED)));
    }

    private void processSemanticTerms(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        TypeSemanticTermsUtils.enrichWithTypeAnnotation(field2, fieldBuilder);
    }

    private void processNullSafe(Class<?> declaringClass, Field field2, ObjectFieldTypeBuilder fieldBuilder, TypeHandlerManager typeHandlerManager, ParsingContext context) {
        Optional<Class<?>> defaultImplementedType = JavaParserUtils.getNullSafeDefaultImplementedType(field2);
        if (defaultImplementedType.isPresent()) {
            if (!TypeUtils.isOptional(field2) && !TypeUtils.isParameterGroup(field2)) {
                throw new IllegalParameterModelDefinitionException(String.format("Field '%s' in class '%s' is required but annotated with '@%s', which is redundant", field2.getName(), declaringClass.getName(), NullSafe.class.getSimpleName()));
            }
            Class<?> defaultType = defaultImplementedType.get();
            if (defaultType.equals(Object.class)) {
                fieldBuilder.with(new NullSafeTypeAnnotation(field2.getType(), false));
            } else {
                fieldBuilder.with(new NullSafeTypeAnnotation(defaultType, true));
                Optional<TypeBuilder<?>> typeBuilder = context.getTypeBuilder(defaultType);
                if (typeBuilder.isPresent()) {
                    fieldBuilder.with(new DefaultImplementingTypeAnnotation((MetadataType)typeBuilder.get().build()));
                } else {
                    BaseTypeBuilder defaultTypeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
                    typeHandlerManager.handle(defaultType, context, defaultTypeBuilder);
                    fieldBuilder.with(new DefaultImplementingTypeAnnotation(defaultTypeBuilder.build()));
                }
            }
        }
    }

    private void processConfigOverride(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        if (JavaParserUtils.isConfigOverride(field2)) {
            fieldBuilder.required(false);
            fieldBuilder.with(new ConfigOverrideTypeAnnotation());
        }
    }

    private void processElementReference(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        ConfigReference ref2;
        ConfigReferences references = field2.getAnnotation(ConfigReferences.class);
        if (references != null) {
            Arrays.stream(references.value()).map(ref -> new StereotypeTypeAnnotation(Collections.singletonList(StereotypeModelBuilder.newStereotype(ref.name(), ref.namespace()).withParent(MuleStereotypes.CONFIG).build()))).forEach(fieldBuilder::with);
        }
        if ((ref2 = field2.getAnnotation(ConfigReference.class)) != null) {
            fieldBuilder.with(new StereotypeTypeAnnotation(Collections.singletonList(StereotypeModelBuilder.newStereotype(ref2.name(), ref2.namespace()).withParent(MuleStereotypes.CONFIG).build())));
        }
        if (field2.getAnnotation(FlowReference.class) != null) {
            if (Boolean.getBoolean("mule.flowReference.matchesAny")) {
                fieldBuilder.with(new StereotypeTypeAnnotation(Arrays.asList(MuleStereotypes.FLOW, MuleStereotypes.SUB_FLOW, MuleStereotypes.OBJECT_STORE, MuleStereotypes.CONFIG)));
            } else {
                fieldBuilder.with(new StereotypeTypeAnnotation(Collections.singletonList(MuleStereotypes.FLOW)));
            }
        }
        if (field2.getAnnotation(ObjectStoreReference.class) != null) {
            fieldBuilder.with(new StereotypeTypeAnnotation(Collections.singletonList(MuleStereotypes.OBJECT_STORE)));
        }
    }

    private void processElementStyle(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl legacyAnnotation = field2.getAnnotation(org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class);
        ParameterDsl sdkAnnotation = field2.getAnnotation(ParameterDsl.class);
        if (legacyAnnotation != null && sdkAnnotation != null) {
            throw new IllegalModelDefinitionException(String.format("Parameter '%s' is annotated with '@%s' and '@%s' at the same time", field2.getName(), org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl.class.getName(), ParameterDsl.class.getName()));
        }
        if (legacyAnnotation != null) {
            fieldBuilder.with(new ParameterDslAnnotation(legacyAnnotation.allowInlineDefinition(), legacyAnnotation.allowReferences()));
        } else if (sdkAnnotation != null) {
            fieldBuilder.with(new ParameterDslAnnotation(sdkAnnotation.allowInlineDefinition(), sdkAnnotation.allowReferences()));
        }
    }

    private void setOptionalAndDefault(Field field2, ObjectFieldTypeBuilder fieldBuilder) {
        Optional<Content> contentAnnotation = Optional.ofNullable(field2.getAnnotation(Content.class));
        fieldBuilder.required(true);
        contentAnnotation.ifPresent(content -> {
            if (content.primary()) {
                fieldBuilder.required(false);
                if (ExtensionModelUtils.getDefaultValue(field2) == null) {
                    fieldBuilder.with(new DefaultValueAnnotation("#[payload]"));
                }
            }
        });
        if (TypeUtils.isOptional(field2)) {
            this.optionalField(fieldBuilder, (String)ExtensionModelUtils.getDefaultValue(field2));
        }
        if (Boolean.class.isAssignableFrom(field2.getType()) || Boolean.TYPE.isAssignableFrom(field2.getType())) {
            fieldBuilder.required(false);
            if (ExtensionModelUtils.getDefaultValue(field2) == null && !JavaParserUtils.isConfigOverride(field2)) {
                fieldBuilder.with(new DefaultValueAnnotation(String.valueOf(Boolean.FALSE)));
            }
        }
    }

    private void fallbackToBeanProperties(Class<?> clazz, TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder builder) {
        if (!clazz.isInterface()) {
            new DefaultObjectFieldHandler().handleFields(clazz, typeHandlerManager, context, builder);
        }
    }

    private void optionalField(ObjectFieldTypeBuilder fieldBuilder, String defaultValue) {
        fieldBuilder.required(false);
        if (defaultValue != null) {
            fieldBuilder.with(new DefaultValueAnnotation(defaultValue));
        }
    }
}

