/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type.annotation;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;

public abstract class PrefixDefinedAnnotation {
    private static final String DELIMITER = ":";
    private String prefix = "";
    private String element = "";

    public PrefixDefinedAnnotation() {
    }

    public PrefixDefinedAnnotation(String prefix, String content) {
        this.setValues(prefix, content);
    }

    public PrefixDefinedAnnotation(String formattedAnnotation) throws IllegalArgumentException {
        if (StringUtils.isBlank(formattedAnnotation)) {
            return;
        }
        String[] splittedAnnotation = formattedAnnotation.split(DELIMITER);
        Preconditions.checkArgument(splittedAnnotation.length == 2, String.format("%s is not a valid format. prefix:content is expected", formattedAnnotation));
        this.setValues(StringUtils.trim(splittedAnnotation[0]), StringUtils.trim(splittedAnnotation[1]));
    }

    void setValues(String prefix, String content) {
        Preconditions.checkArgument(!StringUtils.isBlank(prefix) && !StringUtils.isBlank(content), String.format("prefix and content should both be specified, got prefix: %s and content: %s", prefix, content));
        this.prefix = prefix;
        this.element = content;
    }

    public boolean isDefined() {
        return StringUtils.isNotEmpty(this.prefix) && StringUtils.isNotEmpty(this.element);
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected String getContent() {
        return this.element;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PrefixDefinedAnnotation) {
            return this.prefix.equals(((PrefixDefinedAnnotation)obj).getPrefix()) && this.element.equals(((PrefixDefinedAnnotation)obj).getContent());
        }
        return false;
    }

    public int hashCode() {
        return this.prefix.hashCode() + this.element.hashCode();
    }
}

