/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.notification;

import org.mule.metadata.api.builder.VoidTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.extension.api.model.notification.ImmutableNotificationModel;

public final class NotificationModelBuilder {
    private final String identifier;
    private MetadataType type;
    private String namespace;

    private NotificationModelBuilder(String name, String namespace) {
        this.identifier = name;
        this.namespace = namespace;
    }

    public static NotificationModelBuilder newNotification(String identifier, String namespace) {
        return new NotificationModelBuilder(identifier, namespace);
    }

    public static NotificationModelBuilder newNotification(ComponentIdentifier identifier) {
        return NotificationModelBuilder.newNotification(identifier.getName(), identifier.getNamespace());
    }

    public NotificationModelBuilder withType(MetadataType type) {
        this.type = type;
        return this;
    }

    public NotificationModel build() {
        return new ImmutableNotificationModel(this.namespace, this.identifier, this.type == null ? new VoidTypeBuilder(MetadataFormat.JAVA).build() : this.type);
    }
}

