/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class HierarchyClassMap<V>
implements Map<Class<?>, V> {
    private final Map<Class<?>, V> delegate;

    public HierarchyClassMap() {
        this(new LinkedHashMap());
    }

    public HierarchyClassMap(Map<Class<?>, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public V get(Object key) {
        if (this.delegate.containsKey(key)) {
            return this.delegate.get(key);
        }
        for (Class searchKey = (Class)key; searchKey != null && !Object.class.equals((Object)searchKey); searchKey = searchKey.getSuperclass()) {
            V value = this.searchAssignableFrom(searchKey);
            if (value == null) {
                continue;
            }
            return value;
        }
        return null;
    }

    private V searchAssignableFrom(Class<?> searchKey) {
        return this.entrySet().stream().filter(entry -> searchKey.isAssignableFrom((Class)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.delegate.containsKey(key)) {
            return true;
        }
        for (Class searchKey = (Class)key; searchKey != null && !Object.class.equals((Object)searchKey); searchKey = searchKey.getSuperclass()) {
            Class lambdaKey = searchKey;
            Optional<Class> foundKey = this.delegate.keySet().stream().filter(clazz -> lambdaKey.isAssignableFrom((Class<?>)clazz)).findFirst();
            if (!foundKey.isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V put(Class<?> key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends Class<?>, ? extends V> m4) {
        this.delegate.putAll(m4);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<Class<?>> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<Class<?>, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.containsKey(key) ? this.get(key) : defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super Class<?>, ? super V> action) {
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super Class<?>, ? super V, ? extends V> function) {
        this.delegate.replaceAll(function);
    }

    @Override
    public V putIfAbsent(Class<?> key, V value) {
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(Class<?> key, V oldValue, V newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(Class<?> key, V value) {
        return this.delegate.replace(key, value);
    }

    @Override
    public V computeIfAbsent(Class<?> key, Function<? super Class<?>, ? extends V> mappingFunction) {
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public V computeIfPresent(Class<?> key, BiFunction<? super Class<?>, ? super V, ? extends V> remappingFunction) {
        return this.delegate.computeIfPresent(key, remappingFunction);
    }

    @Override
    public V compute(Class<?> key, BiFunction<? super Class<?>, ? super V, ? extends V> remappingFunction) {
        return this.delegate.compute(key, remappingFunction);
    }

    @Override
    public V merge(Class<?> key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.delegate.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }
}

