/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.type.DynamicConfigExpirationTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.ErrorMappingsTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.PoolingProfileTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.ReconnectionStrategyTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.RedeliveryPolicyTypeBuilder;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.property.SinceMuleVersionModelProperty;
import org.mule.runtime.extension.api.util.XmlModelUtils;

public final class InfrastructureParameterBuilder {
    private static final String RECONNECTION_CONFIG_TYPE_KEY = "reconnectionConfig";
    private static final String RECONNECTION_STRATEGY_TYPE_KEY = "reconnectionStrategy";
    private static final String POOLING_PROFILE_TYPE_KEY = "poolingProfile";
    private static final String REDELIVERY_POLICY_TYPE_KEY = "redeliveryPolicy";
    private static final String DYNAMIC_EXPIRATION_TYPE_KEY = "expirationPolicy";
    private static final String ERROR_MAPPINGS_TYPE_KEY = "errorMappings";
    private static final LoadingCache<String, MetadataType> METADATA_TYPES_CACHE = Caffeine.newBuilder().weakValues().build(key -> {
        switch (key) {
            case "reconnectionConfig": {
                return new ReconnectionStrategyTypeBuilder().buildReconnectionConfigType();
            }
            case "reconnectionStrategy": {
                return new ReconnectionStrategyTypeBuilder().buildReconnectionStrategyType();
            }
            case "poolingProfile": {
                return new PoolingProfileTypeBuilder().buildPoolingProfileType();
            }
            case "redeliveryPolicy": {
                return new RedeliveryPolicyTypeBuilder().buildRedeliveryPolicyType();
            }
            case "expirationPolicy": {
                return new DynamicConfigExpirationTypeBuilder().buildExpirationPolicyType();
            }
            case "errorMappings": {
                return new ErrorMappingsTypeBuilder().buildErrorMappingsType();
            }
        }
        throw new NoSuchElementException((String)key);
    });

    private InfrastructureParameterBuilder() {
    }

    public static void addReconnectionConfigParameter(ParameterizedDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration("reconnection");
        parameter.setDescription("When the application is deployed, a connectivity test is performed on all connectors. If set to true, deployment will fail if the test doesn't pass after exhausting the associated reconnection strategy");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(METADATA_TYPES_CACHE.get(RECONNECTION_CONFIG_TYPE_KEY), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_DEFAULT_RECONNECTION_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 3);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }

    public static void addPrimaryNodeParameter(SourceDeclaration declaration, boolean defaultValue) {
        ParameterDeclaration parameter = new ParameterDeclaration("primaryNodeOnly");
        parameter.setDescription("Whether this source should only be executed on the primary node when runnning in Cluster");
        parameter.setType(BaseTypeBuilder.create(MetadataFormat.JAVA).booleanType().build(), false);
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setDefaultValue(defaultValue);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        declaration.getParameterGroup("General").addParameter(parameter);
    }

    public static void addReconnectionStrategyParameter(ParameterizedDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration(RECONNECTION_STRATEGY_TYPE_KEY);
        parameter.setDescription("A retry strategy in case of connectivity errors");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(METADATA_TYPES_CACHE.get(RECONNECTION_STRATEGY_TYPE_KEY), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_RECONNECTION_STRATEGY_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 3);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }

    public static void addPoolingProfileParameter(ConnectionProviderDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration(POOLING_PROFILE_TYPE_KEY);
        parameter.setDescription("Characteristics of the connection pool");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(METADATA_TYPES_CACHE.get(POOLING_PROFILE_TYPE_KEY), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_POOLING_PROFILE_TYPE_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 5);
        declaration.getParameterGroup("Connection").addParameter(parameter);
    }

    public static void addRedeliveryPolicy(ParameterizedDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration(REDELIVERY_POLICY_TYPE_KEY);
        parameter.setDescription("Defines a policy for processing the redelivery of the same message");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(METADATA_TYPES_CACHE.get(REDELIVERY_POLICY_TYPE_KEY), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Redelivery").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_REDELIVERY_POLICY_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 1);
        declaration.getParameterGroup("General").addParameter(parameter);
    }

    public static ParameterDeclaration addStreamingParameter(ComponentDeclaration declaration, MetadataType type, QName qName) {
        ParameterDeclaration parameter = new ParameterDeclaration("streamingStrategy");
        parameter.setDescription("Configure if repeatable streams should be used and their behaviour");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(type, false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(qName));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 2);
        declaration.getParameterGroup("General").addParameter(parameter);
        return parameter;
    }

    public static ParameterDeclaration addExpirationPolicy(ConfigurationDeclaration config) {
        ParameterDeclaration parameter = new ParameterDeclaration(DYNAMIC_EXPIRATION_TYPE_KEY);
        parameter.setDescription("Configures the minimum amount of time that a dynamic configuration instance can remain idle before the runtime considers it eligible for expiration. This does not mean that the platform will expire the instance at the exact moment that it becomes eligible. The runtime will actually purge the instances when it sees it fit.");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(METADATA_TYPES_CACHE.get(DYNAMIC_EXPIRATION_TYPE_KEY), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_EXPIRATION_POLICY_QNAME));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 4);
        config.getParameterGroup("General").addParameter(parameter);
        return parameter;
    }

    public static ParameterDeclaration addErrorMappings(OperationDeclaration operation) {
        ParameterDeclaration parameter = new ParameterDeclaration(ERROR_MAPPINGS_TYPE_KEY);
        parameter.setDescription("Set of error mappings");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(METADATA_TYPES_CACHE.get(ERROR_MAPPINGS_TYPE_KEY), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Error Mapping").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ERROR_MAPPINGS_QNAME));
        parameter.addModelProperty(new SinceMuleVersionModelProperty("4.4.0"));
        InfrastructureParameterBuilder.markAsInfrastructure(parameter, 12);
        ParameterGroupDeclaration errorMappingsGroup = operation.getParameterGroup("Error Mappings");
        errorMappingsGroup.showInDsl(false);
        errorMappingsGroup.addParameter(parameter);
        return parameter;
    }

    private static void markAsInfrastructure(ParameterDeclaration parameter, int sequence) {
        parameter.addModelProperty(new InfrastructureParameterModelProperty(sequence));
    }
}

