/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.loader.validator.ModelValidationUtils;

public final class ConfigurationModelValidator
implements ExtensionModelValidator {
    private static final Map<String, Set<String>> allowlistedExtensionsConfigurations = ImmutableMap.of("cxf", ImmutableSet.of("wsSecurity", "configuration"));

    @Override
    public void validate(ExtensionModel model, final ProblemsReporter problemsReporter) {
        final Set allowListed = allowlistedExtensionsConfigurations.getOrDefault(model.getName(), Collections.emptySet());
        new ExtensionWalker(){

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                if (!allowListed.contains(model.getName())) {
                    ModelValidationUtils.validateConfigParametersNamesNotAllowed(model, problemsReporter, "Configuration");
                }
                ModelValidationUtils.validateConfigOverrideParametersNotAllowed(model, problemsReporter, "Configuration");
            }
        }.walk(model);
    }
}

