/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import com.google.common.collect.HashMultiset;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class ConnectionProviderNameModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) throws IllegalModelDefinitionException {
        final HashMultiset names = HashMultiset.create();
        final HashSet models = new HashSet();
        new IdempotentExtensionWalker(){

            @Override
            public void onConnectionProvider(ConnectionProviderModel model) {
                models.add(model);
                names.add(model.getName());
            }
        }.walk(model);
        Set repeatedNameModels = models.stream().filter(cp -> names.count(cp.getName()) > 1).collect(Collectors.toSet());
        if (!repeatedNameModels.isEmpty()) {
            problemsReporter.addError(new Problem(model, String.format("There are %d connection providers with repeated names. Offending names are: [%s]", repeatedNameModels.size(), repeatedNameModels.stream().map(NamedObject::getName).collect(Collectors.joining(",")))));
        }
    }
}

