/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.feature.internal.togglz.state;

import java.util.Collections;
import java.util.Map;
import org.mule.runtime.feature.internal.togglz.provider.MuleTogglzFeatureProvider;
import org.mule.runtime.feature.internal.togglz.scope.MuleTogglzFeatureScope;
import org.mule.runtime.feature.internal.togglz.scope.type.MuleTogglzFeatureScopeType;
import org.mule.runtime.feature.internal.togglz.state.MuleTogglzApplicationFeatureStateResolver;
import org.mule.runtime.feature.internal.togglz.state.MuleTogglzFeatureState;
import org.mule.runtime.feature.internal.togglz.state.MuleTogglzFeatureStateResolver;
import org.mule.runtime.feature.internal.togglz.state.MuleTogglzRuntimeFeatureStateResolver;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.user.FeatureUser;

public class MuleTogglzFeatureStateRepository
implements StateRepository {
    private final Map<MuleTogglzFeatureScopeType, MuleTogglzFeatureStateResolver> featureResolvers = Collections.singletonMap(MuleTogglzFeatureScopeType.ARTIFACT_SCOPE_TYPE, new MuleTogglzApplicationFeatureStateResolver(this));
    public static final String INVALID_FEATURE_SCOPE_ATTRIBUTE = "Invalid feature scope attribute";
    public static final String FEATURE_IS_NOT_REGISTERED = "Feature '%s' is not registered";
    private final MuleTogglzFeatureStateResolver defaultFeatureStateResolver = new MuleTogglzRuntimeFeatureStateResolver(this);
    private final MuleTogglzFeatureProvider featureProvider;

    public MuleTogglzFeatureStateRepository(MuleTogglzFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    @Override
    public FeatureState getFeatureState(Feature feature) {
        if (this.featureProvider.getFeature(feature.name()) == null) {
            throw new IllegalArgumentException(String.format(FEATURE_IS_NOT_REGISTERED, feature.name()));
        }
        MuleTogglzFeatureScope scope = this.getScope();
        return this.getFeatureStateResolver(scope).getFeatureState(feature, scope);
    }

    @Override
    public void setFeatureState(FeatureState featureState) {
        MuleTogglzFeatureScope scope = this.getScope();
        this.getFeatureStateResolver(scope).setFeatureState(scope, featureState);
    }

    private MuleTogglzFeatureScope getScope() {
        FeatureUser featureUser = FeatureContext.getFeatureManager().getCurrentFeatureUser();
        if (featureUser == null) {
            return null;
        }
        Object scope = featureUser.getAttribute("FEATURE_SCOPE_ATTRIBUTE_KEY");
        if (scope != null && !(scope instanceof MuleTogglzFeatureScope)) {
            throw new IllegalStateException(INVALID_FEATURE_SCOPE_ATTRIBUTE);
        }
        return (MuleTogglzFeatureScope)scope;
    }

    public void removeFeatureState(FeatureState muleFeatureState) {
        if (!(muleFeatureState instanceof MuleTogglzFeatureState)) {
            throw new IllegalArgumentException("The Mule Feature State Repository can only remove Mule Feature States");
        }
        MuleTogglzFeatureState muleTogglzFeatureState = (MuleTogglzFeatureState)muleFeatureState;
        this.getFeatureStateResolver(muleTogglzFeatureState.getScope()).removeFeatureFeature(muleTogglzFeatureState);
    }

    private MuleTogglzFeatureStateResolver getFeatureStateResolver(MuleTogglzFeatureScope scope) {
        if (scope == null) {
            return this.defaultFeatureStateResolver;
        }
        return this.featureResolvers.getOrDefault((Object)scope.getScopeType(), this.defaultFeatureStateResolver);
    }
}

