/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.core.io;

import java.nio.ByteBuffer;
import org.mule.weave.v2.core.io.ByteBufferPool;
import org.mule.weave.v2.core.io.MemoryService;
import org.mule.weave.v2.core.io.MemoryServiceMonitor;
import org.mule.weave.v2.core.io.PooledDirectMemoryService$;
import org.mule.weave.v2.model.service.SettingsService;
import scala.None$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\u000b\u0016\u0001\tB\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005]!A!\u0007\u0001B\u0001B\u0003%1\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u0003/\u0011\u00159\u0004\u0001\"\u00019\u0011!q\u0004\u0001#b\u0001\n\u0013y\u0004\u0002C\"\u0001\u0011\u000b\u0007I\u0011B \t\u0011\u0011\u0003\u0001R1A\u0005\n}Bq!\u0012\u0001C\u0002\u0013%a\t\u0003\u0004K\u0001\u0001\u0006Ia\u0012\u0005\u0006\u0017\u0002!\t\u0005\u0014\u0005\u0006\u001b\u0002!\tE\u0014\u0005\u0006I\u0002!\t%\u001a\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006G\u0002!\t\u0001T\u0004\u0006oVA\t\u0001\u001f\u0004\u0006)UA\t!\u001f\u0005\u0006oE!\tA\u001f\u0005\u0006wF!\t\u0001 \u0002\u001a!>|G.\u001a3ESJ,7\r^'f[>\u0014\u0018pU3sm&\u001cWM\u0003\u0002\u0017/\u0005\u0011\u0011n\u001c\u0006\u00031e\tAaY8sK*\u0011!dG\u0001\u0003mJR!\u0001H\u000f\u0002\u000b],\u0017M^3\u000b\u0005yy\u0012\u0001B7vY\u0016T\u0011\u0001I\u0001\u0004_J<7\u0001A\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002+W5\tQ#\u0003\u0002-+\tiQ*Z7pef\u001cVM\u001d<jG\u0016\f\u0001bY1qC\u000eLG/\u001f\t\u0003I=J!\u0001M\u0013\u0003\u0007%sG/A\u0004nCb\u001c\u0016N_3\u0002!Q,G.Z7fiJLXI\\1cY\u0016$\u0007C\u0001\u00135\u0013\t)TEA\u0004C_>dW-\u00198\u00025\u0011,g-Y;mi\nKH/Z!se\u0006L()\u001e4gKJ\u001c\u0016N_3\u0002\rqJg.\u001b;?)\u0015I$h\u000f\u001f>!\tQ\u0003\u0001C\u0003.\u000b\u0001\u0007a\u0006C\u00032\u000b\u0001\u0007a\u0006C\u00033\u000b\u0001\u00071\u0007C\u00037\u000b\u0001\u0007a&\u0001\u0007eSJ,7\r^'f[>\u0014\u00180F\u0001A!\tQ\u0013)\u0003\u0002C+\t!R*Z7pef\u001cVM\u001d<jG\u0016luN\\5u_J\f!\u0002[3ba6+Wn\u001c:z\u0003Y\u0011\u0017\u0010^3BeJ\f\u00170T3n_JLXj\u001c8ji>\u0014\u0018\u0001\u00029p_2,\u0012a\u0012\t\u0003U!K!!S\u000b\u0003\u001d\tKH/\u001a\"vM\u001a,'\u000fU8pY\u0006)\u0001o\\8mA\u0005\tB-\u001a4bk2$()\u001e4gKJ\u001c\u0016N_3\u0015\u00039\nAB\\3x\u0005f$X-\u0011:sCf$2aT+c!\r!\u0003KU\u0005\u0003#\u0016\u0012Q!\u0011:sCf\u0004\"\u0001J*\n\u0005Q+#\u0001\u0002\"zi\u0016DQA\u0016\u0007A\u0002]\u000b!!\u001b3\u0011\u0005a{fBA-^!\tQV%D\u0001\\\u0015\ta\u0016%\u0001\u0004=e>|GOP\u0005\u0003=\u0016\na\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011a,\n\u0005\u0006G2\u0001\rAL\u0001\u0005g&TX-\u0001\u0003uC.,GC\u00014o!\t9G.D\u0001i\u0015\tI'.A\u0002oS>T\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bYk\u0001\u0019A,\u0002\u000fI,G.Z1tKR\u0019\u0011\u000f\u001e<\u0011\u0005\u0011\u0012\u0018BA:&\u0005\u0011)f.\u001b;\t\u000bUt\u0001\u0019\u00014\u0002\u0015\tLH/\u001a\"vM\u001a,'\u000fC\u0003W\u001d\u0001\u0007q+A\rQ_>dW\r\u001a#je\u0016\u001cG/T3n_JL8+\u001a:wS\u000e,\u0007C\u0001\u0016\u0012'\t\t2\u0005F\u0001y\u0003\u0015\t\u0007\u000f\u001d7z)\tIT\u0010C\u0003\u007f'\u0001\u0007q0A\btKR$\u0018N\\4t'\u0016\u0014h/[2f!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\tqa]3sm&\u001cWMC\u0002\u0002\ne\tQ!\\8eK2LA!!\u0004\u0002\u0004\ty1+\u001a;uS:<7oU3sm&\u001cW\r")
public class PooledDirectMemoryService
implements MemoryService {
    private MemoryServiceMonitor directMemory;
    private MemoryServiceMonitor heapMemory;
    private MemoryServiceMonitor byteArrayMemoryMonitor;
    private final int capacity;
    private final int maxSize;
    private final boolean telemetryEnabled;
    private final int defaultByteArrayBufferSize;
    private final ByteBufferPool pool;
    private volatile byte bitmap$0;

    public static PooledDirectMemoryService apply(SettingsService settingsService) {
        return PooledDirectMemoryService$.MODULE$.apply(settingsService);
    }

    @Override
    public byte[] byteArrayBuffer(String id) {
        return MemoryService.byteArrayBuffer$(this, id);
    }

    private MemoryServiceMonitor directMemory$lzycompute() {
        PooledDirectMemoryService pooledDirectMemoryService = this;
        synchronized (pooledDirectMemoryService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.directMemory = new MemoryServiceMonitor("Direct", new Some<Object>(BoxesRunTime.boxToInteger(this.maxSize * this.capacity)));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.directMemory;
    }

    private MemoryServiceMonitor directMemory() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.directMemory$lzycompute() : this.directMemory;
    }

    private MemoryServiceMonitor heapMemory$lzycompute() {
        PooledDirectMemoryService pooledDirectMemoryService = this;
        synchronized (pooledDirectMemoryService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.heapMemory = new MemoryServiceMonitor("Heap", None$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.heapMemory;
    }

    private MemoryServiceMonitor heapMemory() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.heapMemory$lzycompute() : this.heapMemory;
    }

    private MemoryServiceMonitor byteArrayMemoryMonitor$lzycompute() {
        PooledDirectMemoryService pooledDirectMemoryService = this;
        synchronized (pooledDirectMemoryService) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.byteArrayMemoryMonitor = new MemoryServiceMonitor("Heap_ByteArray", None$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.byteArrayMemoryMonitor;
    }

    private MemoryServiceMonitor byteArrayMemoryMonitor() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.byteArrayMemoryMonitor$lzycompute() : this.byteArrayMemoryMonitor;
    }

    private ByteBufferPool pool() {
        return this.pool;
    }

    @Override
    public int defaultBufferSize() {
        return this.defaultByteArrayBufferSize;
    }

    @Override
    public byte[] newByteArray(String id, int size) {
        block0: {
            if (!this.telemetryEnabled) break block0;
            this.byteArrayMemoryMonitor().taken(size, id);
        }
        return new byte[size];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer take(String id) {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = this.pool().take();
        if (byteBuffer2 == null) {
            if (this.telemetryEnabled) {
                this.heapMemory().taken(this.capacity, id);
            }
            byteBuffer = ByteBuffer.allocate(this.capacity);
        } else {
            void var2_2;
            if (this.telemetryEnabled) {
                this.directMemory().taken(this.capacity, id);
            }
            byteBuffer = var2_2;
        }
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer, String id) {
        block2: {
            block1: {
                if (!byteBuffer.isDirect() || byteBuffer.capacity() != this.capacity) break block1;
                if (this.telemetryEnabled) {
                    this.directMemory().release(this.capacity, id);
                }
                this.pool().release(byteBuffer);
                break block2;
            }
            if (!this.telemetryEnabled) break block2;
            this.heapMemory().release(this.capacity, id);
        }
    }

    public int size() {
        return this.pool().size();
    }

    public PooledDirectMemoryService(int capacity, int maxSize, boolean telemetryEnabled, int defaultByteArrayBufferSize) {
        this.capacity = capacity;
        this.maxSize = maxSize;
        this.telemetryEnabled = telemetryEnabled;
        this.defaultByteArrayBufferSize = defaultByteArrayBufferSize;
        MemoryService.$init$(this);
        this.pool = new ByteBufferPool(capacity, maxSize);
    }
}

