/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.flatfile;

import com.mulesoft.flatfile.schema.model.EdiForm$;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.yaml.YamlReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class SchemaCache$ {
    public static SchemaCache$ MODULE$;
    private final ConcurrentHashMap<String, Tuple2<Object, EdiSchema>> schemaFileCache;
    private final WeakHashMap<ClassLoader, ConcurrentHashMap<String, EdiSchema>> contextMapCache;

    static {
        new SchemaCache$();
    }

    public ConcurrentHashMap<String, Tuple2<Object, EdiSchema>> schemaFileCache() {
        return this.schemaFileCache;
    }

    public WeakHashMap<ClassLoader, ConcurrentHashMap<String, EdiSchema>> contextMapCache() {
        return this.contextMapCache;
    }

    public EdiSchema loadCachedFileSchema(File file) {
        EdiSchema ediSchema;
        String abspath = file.getAbsolutePath();
        if (this.schemaFileCache().containsKey(abspath)) {
            Tuple2<Object, EdiSchema> tuple2 = this.schemaFileCache().get(abspath);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long modified = tuple2._1$mcJ$sp();
            EdiSchema schema = tuple2._2();
            Tuple2<Long, EdiSchema> tuple22 = new Tuple2<Long, EdiSchema>(BoxesRunTime.boxToLong(modified), schema);
            Tuple2<Long, EdiSchema> tuple23 = tuple22;
            long modified2 = tuple23._1$mcJ$sp();
            EdiSchema schema2 = tuple23._2();
            if (modified2 >= file.lastModified()) {
                ediSchema = schema2;
            } else {
                this.schemaFileCache().remove(abspath);
                ediSchema = this.fileToCache$1(file, abspath);
            }
        } else {
            ediSchema = this.fileToCache$1(file, abspath);
        }
        return ediSchema;
    }

    public EdiSchema loadCachedClasspathSchema(String path, ClassLoader ctx, ConcurrentHashMap<String, EdiSchema> map) {
        EdiSchema ediSchema;
        if (map.containsKey(path)) {
            ediSchema = map.get(path);
        } else {
            InputStream inputStream;
            InputStream is0 = this.getClass().getResourceAsStream(path);
            if (is0 == null) {
                String relpath = path.startsWith("/") ? path.substring(1) : path;
                InputStream is1 = this.getClass().getClassLoader().getResourceAsStream(relpath);
                if (is1 == null) {
                    InputStream is2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(relpath);
                    if (is2 == null) {
                        throw new IllegalArgumentException(new StringBuilder(32).append("file ").append(path).append(" not found on any classpath").toString());
                    }
                    inputStream = is2;
                } else {
                    inputStream = is1;
                }
            } else {
                inputStream = is0;
            }
            InputStream is = inputStream;
            try (InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF-8"));){
                EdiSchema schema = new YamlReader(EdiForm$.MODULE$).loadYaml(reader, Nil$.MODULE$);
                map.put(path, schema);
                ediSchema = schema;
            }
        }
        return ediSchema;
    }

    public EdiSchema loadCached(String path) {
        EdiSchema ediSchema;
        File file = new File(path);
        if (file.exists()) {
            ediSchema = this.loadCachedFileSchema(file);
        } else {
            ConcurrentHashMap<String, EdiSchema> concurrentHashMap;
            ClassLoader context = Thread.currentThread().getContextClassLoader();
            WeakHashMap<ClassLoader, ConcurrentHashMap<String, EdiSchema>> weakHashMap = this.contextMapCache();
            synchronized (weakHashMap) {
                ConcurrentHashMap<String, EdiSchema> concurrentHashMap2;
                if (this.contextMapCache().containsKey(context)) {
                    concurrentHashMap2 = this.contextMapCache().get(context);
                } else {
                    ConcurrentHashMap newmap = new ConcurrentHashMap();
                    this.contextMapCache().put(context, newmap);
                    concurrentHashMap2 = newmap;
                }
                concurrentHashMap = concurrentHashMap2;
            }
            ConcurrentHashMap<String, EdiSchema> ctxmap = concurrentHashMap;
            ediSchema = this.loadCachedClasspathSchema(path, context, ctxmap);
        }
        return ediSchema;
    }

    private final EdiSchema fileToCache$1(File file$1, String abspath$1) {
        EdiSchema ediSchema;
        long modified = file$1.lastModified();
        try (FileReader reader = new FileReader(file$1);){
            YamlReader yamlReader = new YamlReader(EdiForm$.MODULE$);
            EdiSchema schema = yamlReader.loadYaml(reader, Nil$.MODULE$);
            this.schemaFileCache().put(abspath$1, new Tuple2<Long, EdiSchema>(BoxesRunTime.boxToLong(modified), schema));
            ediSchema = schema;
        }
        return ediSchema;
    }

    private SchemaCache$() {
        MODULE$ = this;
        this.schemaFileCache = new ConcurrentHashMap();
        this.contextMapCache = new WeakHashMap();
    }
}

