/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.protobuf.utils;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDateTime;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.values.LocalDateTimeValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.protobuf.utils.MessageParser;
import scala.runtime.BoxesRunTime;

public final class TimestampParser$
implements MessageParser<Timestamp, LocalDateTime> {
    public static TimestampParser$ MODULE$;

    static {
        new TimestampParser$();
    }

    @Override
    public boolean accepts(Message msg) {
        return MessageParser.accepts$((MessageParser)this, msg);
    }

    @Override
    public boolean accepts(Descriptors.GenericDescriptor desc) {
        return MessageParser.accepts$((MessageParser)this, desc);
    }

    @Override
    public Message fromDw(Value value, EvaluationContext ctx) {
        return MessageParser.fromDw$(this, value, ctx);
    }

    @Override
    public Value<LocalDateTime> toDw(Message msg) {
        return MessageParser.toDw$(this, msg);
    }

    @Override
    public String descriptorName() {
        return "google.protobuf.Timestamp";
    }

    @Override
    public Timestamp doFromDw(Value<?> value, EvaluationContext ctx) {
        Instant dateTime = ((ChronoLocalDateTime)LocalDateTimeType$.MODULE$.coerce(value, ctx).evaluate(ctx)).toInstant(ZoneOffset.UTC);
        return Timestamp.newBuilder().setSeconds(dateTime.getEpochSecond()).setNanos(dateTime.getNano()).build();
    }

    @Override
    public Value<LocalDateTime> doToDw(Message msg) {
        int nanos = BoxesRunTime.unboxToInt(msg.getField(msg.getDescriptorForType().findFieldByName("nanos")));
        long seconds = BoxesRunTime.unboxToLong(msg.getField(msg.getDescriptorForType().findFieldByName("seconds")));
        return LocalDateTimeValue$.MODULE$.apply(LocalDateTime.ofEpochSecond(seconds, nanos, ZoneOffset.UTC));
    }

    private TimestampParser$() {
        MODULE$ = this;
        MessageParser.$init$(this);
    }
}

